/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdssharemodel.h"
#include <QMessageBox>
#include <QDebug>
#include <RdsShare>
#include <RdsFileManager>
#include "config.h"

RdsShareModel::RdsShareModel(RdsShareManager *manager, QObject *parent)
		: RdsEntityModel(manager, 2, parent)
{
	_manager = manager;
	setCachedPixmap("share", QPixmap(findRdsIcon("./icons/16x16/folder_html.png")));
	setCachedPixmap("folder", QPixmap(findRdsIcon("./icons/16x16/folder.png")));
}


RdsShareModel::~RdsShareModel()
{

}

QVariant RdsShareModel::userData(const QModelIndex &index, int role, RdsEntityModel::Cache *cache) const
{
	Q_UNUSED(index);

	
	if ((role == Qt::DecorationRole) && (index.column() == 0))
	{
		return(cachedPixmap(cache->type()));
	}
	if ((role == Qt::DisplayRole) && (index.column() == 1))
	{
		return(cache->metadata()["description"]);
	}

	return(QVariant());
}

QVariant RdsShareModel::userHeaderData(int section, int role) const
{
	if (role == Qt::DisplayRole)
	{
		if (section == 0)
		{
			return("Shares");
		}
		else 	if (section == 1)
		{
			return("Description");
		}
	}

	return(QVariant());
}

Qt::ItemFlags RdsShareModel::flags(const QModelIndex &index, Cache *cache) const
{
	Q_UNUSED(index);
	Q_UNUSED(cache);
	if(index.column() == 0) return(Qt::ItemIsEditable);
	else return(0);
}

bool RdsShareModel::setData(const QModelIndex &index, const QVariant &value, int role, Cache *cache)
{
	Q_UNUSED(index);
	Q_UNUSED(role);
	if (cache->name() == value.toString()) return(false); //if the new name is the same, we didn't change anything
	if (value.toString() == "") return(false);

	//qDebug() << "RdsShareModel is renaming something.";
	
	ReturnValue ret;

	if (cache->type() == "share")
	{
		if(!value.toString().contains(QRegExp("^[a-zA-Z0-9 \\-_]+$")))
		{
			QMessageBox::critical(NULL, "Error", "The name may only contain letters, numbers, underscore(_), and hyphen(-).");
			return(false);
		}
		
		ret = _manager->share(cache->name());
		if (ret.isError())
		{
			QMessageBox::critical(NULL, "Error:", "Failed to get share: " + ret.errString());
			return(false);
		}

		RdsShare share = ret;
		ret = share.setName(value.toString());
		if (ret.isError())
		{
			QMessageBox::critical(NULL, "Error:", "Failed to rename share: " + ret.errString());
			return(false);
		}
		
		manager()->renameEntity(cache->id(),"@SHARE/"+value.toString()+"/");
	}
	else if (cache->type() == "folder")
	{
		RdsFileManager mgr;
		
		if(value.toString().contains("/"))
		{
			QMessageBox::critical(NULL, "Error", "The name must not contain the / character.");
			return(false);
		}
		
		ret = mgr.init();
		if (!ret.isError())
		{
			ret = mgr.rename(cache->id(), value.toString());
		}

		if (ret.isError())
		{
			QMessageBox::critical(NULL, "Error:", "Failed to rename folder: " + ret.errString());
			return(false);
		}
	}
	else
	{
		return(false);
	}

	QString newname = ret.toString();
	manager()->renameEntity(cache->id(), newname);

	return(false);
}

void RdsShareModel::move(Cache *entity, Cache *parent)
{
	if (entity->type() == "folder")
	{
		if(parent->id() == "root") return;
	  
		RdsFileManager mgr;
		ReturnValue ret = mgr.init();

		if (ret.isError())
		{
			QMessageBox::critical(NULL, "Error:", "Failed to get service: " + ret.errString());
			return;
		}

		ret = mgr.move(entity->id(), parent->id());

		if (ret.isError())
		{
			QMessageBox::critical(NULL, "Error:", "Failed to move: " + ret.errString());
			return;
		}
	}
	else
	{
		return;
	}
}
