/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsfilesortmodel.h"

RdsFileSortModel::RdsFileSortModel(RdsEntityModel *parent)
		: RdsEntitySortModel(parent)
{
}


RdsFileSortModel::~RdsFileSortModel()
{
}

bool RdsFileSortModel::lessThan(const QModelIndex &left, const QModelIndex &right) const
{
	RdsEntityModel::Cache *leftcache = (RdsEntityModel::Cache *)left.internalPointer();
	RdsEntityModel::Cache *rightcache = (RdsEntityModel::Cache *)right.internalPointer();
	if ((leftcache == NULL) || (rightcache == NULL)) return(false);

	QString lefttype;
	QString righttype;

	//if ((leftcache->children().size() > 0) || (leftcache->isGroup())) lefttype = "__GROUP__";
	lefttype = leftcache->type();
	//if ((rightcache->children().size() > 0) || (rightcache->isGroup())) righttype = "__GROUP__";
	righttype = rightcache->type();

	//if the two items are the same type, use the standard comparison function
	if (lefttype == righttype) return(QSortFilterProxyModel::lessThan(left, right));

	int leftlevel = getLevel(lefttype);
	int rightlevel = getLevel(righttype);

	//If we don't know the type of either item, just use the normal sort method
	if ((leftlevel < 0) || (rightlevel < 0)) return(QSortFilterProxyModel::lessThan(left, right));

	if (leftlevel < rightlevel)
		return(ascending());
	else
		return(!ascending());
}

int RdsFileSortModel::getLevel(QString type) const
{
	if (type == "__GROUP__") return(1);
	if (type == "volume") return(2);
	if (type == "share") return(3);
	if (type == "filesystem") return(4);
	if (type == "folder") return(5);
	else return(-1);
}

