/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSENTITYSORTMODEL_H
#define RDSENTITYSORTMODEL_H

#include <QSortFilterProxyModel>
#include <QxtPimpl>
#include "rdsentitymodel.h"

class RdsEntitySortModelPrivate;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsEntitySortModel : public QSortFilterProxyModel
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsEntitySortModel);
public:
	RdsEntitySortModel(RdsEntityModel *parent = 0);
	~RdsEntitySortModel();
	
	bool filterAcceptsRow(int sourceRow, const QModelIndex &sourceParent) const;
	bool lessThan(const QModelIndex &left, const QModelIndex &right) const;
	void sort(int column, Qt::SortOrder order = Qt::AscendingOrder);
	QStringList hiddenEntities();
	void setHiddenEntities(QStringList ids);
	QStringList hiddenEntitiesRegex();
	void setHiddenEntitiesRegex(QStringList ids);
	QStringList hiddenTypes();
	void setHiddenTypes(QStringList types);
	QStringList visibleIds();
	bool visibleIdsEnabled();
	void setVisibleIds(const QStringList &ids);
	void setVisibleIdsEnabled(bool enabled);
	bool ascending() const;
	bool hasChildren(const QModelIndex &parent) const;
};

#endif
