/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef PERMISSIONSWIDGET_H
#define PERMISSIONSWIDGET_H

#include <QWidget>
#include "ui_permissionswidget.h"
#include <RdsNtAcl>
#include "aclmodel.h"
#include "acemodel.h"
#include <QSortFilterProxyModel>

class PermissionsWidget : public QWidget, private Ui::PermissionsWidget
{
	Q_OBJECT
public:
	Q_PROPERTY(RdsNtAcl acl READ acl WRITE setAcl);

	PermissionsWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~PermissionsWidget();

	void setPath(const QString &path);
	RdsNtAcl acl() const;
	void setAcl(const RdsNtAcl &acl);
	bool forceInherit();
	void reload();

signals:
	void changed();

protected slots:
	void on_AdvancedButton_toggled(bool checked);
	void on_AddAce_clicked();
	void on_RemoveAce_clicked();
	void on_OwnerButton_clicked();
	void on_InheritCheck_clicked(bool inherit);
	void aclClicked(const QModelIndex & index);
	void flagsChanged(RdsAce::AccessFlags allow, RdsAce::AccessFlags deny, RdsAce::Flags flags, RdsAce::Flags lastflags);

private:
	// Struct for storing UI sensitive ACL information
	struct MergedPermissions
	{
		MergedPermissions();
		RdsAce::AccessFlags allow;
		RdsAce::AccessFlags deny;
		RdsAce::AccessFlags inheritedAllow;
		RdsAce::AccessFlags inheritedDeny;
		bool specialAllow;
		bool specialDeny;
	};

	MergedPermissions readSimplePermissions(const RdsSid &sid);
	MergedPermissions readAdvancedPermissions(const RdsSid &sid, const RdsAce::Flags &inheritence, bool inherited);
	bool writePermissions(const RdsAce::AccessFlags &allow, const RdsAce::AccessFlags &deny, const RdsSid &sid, const RdsAce::Flags &old_inheritence, const RdsAce::Flags &new_inheritence);
	void displayOwner(RdsSid sid);
	void selectAcl(RdsSid sid, RdsAce::Flags flags);
	RdsNtAcl _acl;
	QString _path;
	AclModel *_aclmodel;
	QSortFilterProxyModel *_aclsort;
	AceModel *_acemodel;
};

#endif

