/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "multigeneratedpassworddialog.h"
#include "changepassworddialog.h"
#include <RdsUser>
#include <QMessageBox>
#include <QApplication>
#include <QClipboard>
#include <iostream>

MultiGeneratedPasswordDialog::MultiGeneratedPasswordDialog(QStringList users, QWidget* parent, Qt::WFlags fl)
		: QDialog(parent, fl), Ui::MultiGeneratedPasswordDialog()
{
	setupUi(this);
	_users = users;
	
	ReturnValue ret;
	
	QString text;
	
	text.append("<table border='0px' width='100%'>");
	foreach(QString dn, users)
	{
		RdsUser user(dn);
		QString name;
		ret = user.cn();
		if(ret.isError()) name = dn;
		else name = ret.toString();
		
		_names << name;
		
		QString pwd = ChangePasswordDialog::genPassword();
		_passwords << pwd;
		
		text.append("<tr>");
		
		text.append("<td>");
		text.append(name);
		text.append("</td>");
		
		text.append("<td>");
		text.append(pwd);
		text.append("</td>");
		
		text.append("</tr>");
		
		_plaintext.append(QString("%1\t%2\n").arg(name).arg(pwd));
	}
	text.append("</table>");
	
	Text->setHtml(text);
}

MultiGeneratedPasswordDialog::~MultiGeneratedPasswordDialog()
{
}

void MultiGeneratedPasswordDialog::accept()
{
	for(int i = 0; i < _users.size(); i++)
	{
		QString dn = _users[i];
		QString name = _names[i];
		QString pwd = _passwords[i];
		RdsUser user(dn);

		ReturnValue ret = user.setPassword(pwd);
		if (ret.isError())
		{
			QMessageBox::critical(this, "Error", "Failed to set password for " + name + ": " + ret.errString());
			QDialog::accept();
			continue;
		}

		if (MustChangePassword->isChecked())
		{
			ret = user.setFlag(RdsUser::MustChangePassword);
			if (ret.isError())
			{
				QMessageBox::critical(this, "Error", "Failed to set flag " + name + ": " + ret.errString());
			}
		}
	}
	
	QDialog::accept();
}

void MultiGeneratedPasswordDialog::on_CopyButton_clicked()
{
	QApplication::clipboard()->setText(_plaintext);
}

