/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "memberswidget.h"
#include <RdsUser>
#include <RdsGroup>
#include <QDebug>
#include <RdsSid>
#include <QMessageBox>
#include "selectiondialog.h"
#include "config.h"

MembersWidget::MembersWidget(QWidget* parent, Qt::WFlags fl)
		: QWidget(parent, fl), Ui::MembersWidget()
{
	setupUi(this);
	AddButton->setIcon(QPixmap(findRdsIcon("icons/32x32/add.png")));
	RemoveButton->setIcon(QPixmap(findRdsIcon("icons/32x32/remove.png")));
}

MembersWidget::~MembersWidget()
{
}

QStringList MembersWidget::members()
{
	QStringList tmp = _members;
	tmp.sort();
	return(tmp);
}

void MembersWidget::setMembers(QStringList members)
{
	MemberList->clear();
	_members = members;
	_names = QStringList();

	foreach(QString member, members)
	{
		_names << member;
		/*
		//Doesn't matter if we use an RdsUser, or RdsGroup, we use the same attributes
		RdsGroup g(member);
		QString name;
		ReturnValue ret = g.cn();
		if (ret.isError())
			name = member;
		else
			name = ret.toString();

		_names << name;

		QPixmap icon;
		ret = g.readAttribute("objectClass");
		if (ret.isError()) icon = QPixmap(findRdsIcon("./icons/hi32-group.png")).scaled(16, 16);

		LdapValues values = ret.value<LdapValues>();
		if (values.contains(QByteArray("computer")))
			icon = QPixmap(findRdsIcon("./icons/16x16/system.png"));
		else if (values.contains(QByteArray("user")))
			icon = QPixmap(findRdsIcon("./icons/16x16/userconfig.png"));
		else
			icon = QPixmap(findRdsIcon("./icons/hi32-group.png")).scaled(16, 16);

		MemberList->addItem(new QListWidgetItem(icon, name, MemberList));
		*/

		QListWidgetItem *item = new QListWidgetItem(QPixmap(findRdsIcon("./icons/16x16/cancel.png")), member, MemberList);
		MemberList->addItem(item);

		int index = MemberList->row(item);
		ReturnValue ret = rdsLdapSession()->read(this, SLOT(readReturned(uint, ReturnValue)), member, QStringList() << "CN" << "objectClass");

		if (ret.isError())
		{
			qWarning() << "Failed to call read() on member:" << member << ret;
			continue;
		}

		_returnlist[ret.toInt()] = index;
	}
}

void MembersWidget::readReturned(uint id, ReturnValue ret)
{
	if (!_returnlist.contains(id))
	{
		qCritical() << "Unkown ID:" << id;
		return;
	}

	int row = _returnlist[id];
	QListWidgetItem *item = MemberList->item(row);

	if (item == NULL)
	{
		qCritical() << "Item not found at row:" << row;
		return;
	}

	if (ret.isError())
	{
		qWarning() << "Read() failed, row:" << row << ret;
		return;
	}

	LdapResult results = ret.value<LdapResult>();
	if ((!results.contains("cn")) || (results.value("cn").size() == 0))
	{
		qCritical() << "No CN attribute returned for member:" << _members[row];
		return;
	}

	QString name = results["cn"][0];

	QPixmap icon;
	if (ret.isError()) icon = QPixmap(findRdsIcon("./icons/16x16/cancel.png"));

	LdapValues values = results.value("objectclass");
	if (values.contains(QByteArray("computer")))
		icon = QPixmap(findRdsIcon("./icons/16x16/system.png"));
	else if (values.contains(QByteArray("user")))
		icon = QPixmap(findRdsIcon("./icons/16x16/userconfig.png"));
	else
		icon = QPixmap(findRdsIcon("./icons/hi32-group.png")).scaled(16, 16);
	
	item->setIcon(icon);
	item->setText(name);
	_names[row] = name;
}


void MembersWidget::on_AddButton_clicked()
{
	SelectionDialog dialog(SelectionDialog::User | SelectionDialog::Group | SelectionDialog::Computer, this);
	dialog.setAllowMultipleSelections(true);
	if (dialog.exec())
	{
		foreach(QString member, dialog.selectedItems())
		{
			if (_members.contains(member)) continue;

			RdsGroup g(member);
			QString name;
			ReturnValue ret = g.cn();
			if (ret.isError())
				name = member;
			else
				name = ret.toString();

			_names << name;
			_members << member;

			QPixmap icon;
			ret = g.readAttribute("objectClass");
			if (ret.isError()) icon = QPixmap(findRdsIcon("./icons/hi32-group.png")).scaled(16, 16);

			LdapValues values = ret.value<LdapValues>();
			if (values.contains(QByteArray("computer")))
				icon = QPixmap(findRdsIcon("./icons/16x16/system.png"));
			else if (values.contains(QByteArray("user")))
				icon = QPixmap(findRdsIcon("./icons/16x16/userconfig.png"));
			else
				icon = QPixmap(findRdsIcon("./icons/hi32-group.png")).scaled(16, 16);

			MemberList->addItem(new QListWidgetItem(icon, name, MemberList));
		}
		emit(changed());
	}
}

void MembersWidget::on_RemoveButton_clicked()
{
	//qDebug() << "CURRENT ROW:" << GroupList->currentRow();
	if (MemberList->currentRow() < 0) return;
	if (MemberList->currentRow() > _members.size()) return;

	QString dn = _members[MemberList->currentRow()];
	RdsUser user(dn);
	ReturnValue ret = user.readAttribute("objectClass");
	if (!ret.isError())
	{
		//qDebug() << "Got ObjectClass";
		LdapValues values = ret.value<LdapValues>();
		if (values.contains(QByteArray("user")))
		{
			//qDebug() << "Is Uer";
			ret = user.primaryGroup();
			if (!ret.isError())
			{
				//qDebug() << "got group";
				//qDebug() << "pg" << ret.toString();
				if (_dn == ret.toString())
				{
					QMessageBox::critical(this, "Error", QString("The group %1 is the primary group of %2. Please change the primary group before trying to remove %2 from %1.").arg(_cn).arg(user.cn().toString()));
					return;
				}
			}
		}
	}

	_members.removeAt(MemberList->currentRow());
	_names.removeAt(MemberList->currentRow());
	MemberList->takeItem(MemberList->currentRow());

	emit(changed());
}

void MembersWidget::setDn(QString dn)
{
	_dn = dn;

	RdsGroup group(dn);
	ReturnValue ret = group.cn();
	if (!ret.isError())
	{
		_cn = ret.toString();
	}

	ret = group.sid();
	if (!ret.isError())
	{
		RdsSid sid = ret.value<RdsSid>();
		_rid = sid.rid();
	}
}

