/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef LOGINWINDOW_H
#define LOGINWINDOW_H

#include <QDialog>
#include <RdsClient>
#include <QHash>
#include <ServiceFinder>
#include "ui_loginwindow.h"

using namespace QtRpc;

class LoginWindow : public QDialog, private Ui::LoginWindow
{
	Q_OBJECT

	struct ServerEntry
	{
		QString name;
		QString hostname;
		QString address;
		int port;
		QString service;
	};

public:
	LoginWindow(RdsClient *client, QString user, QString pass, QString host, int port, QString service, QWidget* parent = 0, Qt::WFlags fl = 0);
	~LoginWindow();

	QString user();
	QString pass();
	QString host();
	int port();
	QString service();

protected slots:
	void on_LoginButton_clicked();
	void serviceEvent(ServiceFinder::Service service);
	void connectReturned(uint id, ReturnValue ret);
	void textChanged(QString text);

private:
	ReturnValue connect(ServerEntry server);
	RdsClient *_client;
	QtRpc::ServiceFinder *_finder;
	QList<ServerEntry> _servers;
	QString _user;
	QString _pass;
	QString _host;
	QString _oldip;
	QString _service;
	int _port;
	QString _prevuser;
	QString _prevpass;
	QString _lasttext;
};

#endif

