/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "initializevolumedialog.h"
#include <RdsVolume>
#include <RdsStorageDevice>
#include <QTimer>
#include <QDebug>
#include <QMessageBox>
#include "config.h"

InitializeVolumeDialog::InitializeVolumeDialog(QWidget* parent, Qt::WFlags fl)
		: QDialog(parent, fl), Ui::InitializeVolumeDialog()
{
	setupUi(this);

	_loadingframe = 0;
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-0.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-1.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-2.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-3.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-4.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-5.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-6.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-7.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-8.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-9.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-10.png"));
	_loadingframes << QPixmap(findRdsIcon("./icons/loading/loading-11.png"));

	QTimer *timer = new QTimer(this);
	QObject::connect(timer, SIGNAL(timeout()), this, SLOT(onTimerUpdate()));
	timer->start(75);
}

InitializeVolumeDialog::~InitializeVolumeDialog()
{
}

ReturnValue InitializeVolumeDialog::initializeVolume(RdsVolumeManager *manager, QString id)
{
	int result = QMessageBox::warning(this, "Warning", "Initializing this volume will erase all data on this volume. Are you sure you want to continue?", QMessageBox::Yes | QMessageBox::No, QMessageBox::No);

	if (result == QMessageBox::No) return(false); //not really an error

	ReturnValue ret = manager->volume(id);
	if (ret.isError()) return(ret);

	RdsVolume *volume = new RdsVolume();
	*volume = ret;

	QObject::connect(this, SIGNAL(destroyed()), volume, SLOT(deleteLater()));

	return(volume->initialize(this, SLOT(initializeReturned(uint, ReturnValue))));
}

ReturnValue InitializeVolumeDialog::initializeStorageDevice(RdsStorageDeviceManager *manager, QString id)
{
	int result = QMessageBox::warning(this, "Warning", "Initializing this device will erase all data on this device. Are you sure you want to continue?", QMessageBox::Yes | QMessageBox::No, QMessageBox::No);

	if (result == QMessageBox::No) return(false); //not really an error

	ReturnValue ret = manager->device(id);
	if (ret.isError()) return(ret);

	RdsStorageDevice *device = new RdsStorageDevice();
	*device = ret;

	QObject::connect(this, SIGNAL(destroyed()), device, SLOT(deleteLater()));

	return(device->initialize(this, SLOT(initializeReturned(uint, ReturnValue))));
}

ReturnValue InitializeVolumeDialog::result()
{
	return(_result);
}

void InitializeVolumeDialog::reject()
{
	//Does nothing
}

void InitializeVolumeDialog::initializeReturned(uint id, ReturnValue ret)
{
	Q_UNUSED(id);
	_result = ret;
	accept();
	emit(finished(ret));
}

void InitializeVolumeDialog::onTimerUpdate()
{
	if (_loadingframe == 11) _loadingframe = 0;
	else _loadingframe++;

	IconLabel->setPixmap(_loadingframes[_loadingframe]);
}
