/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "groupeditwidget.h"
#include <RdsOrganizationalUnit>
#include <QMessageBox>
#include <QDebug>
#include <RdsEntityManager>
#include <RdsGroup>

GroupEditWidget::GroupEditWidget(RdsEntityManager *manager, QWidget* parent)
		: RdsEntityWidget(manager, parent), Ui::GroupEditWidget()
{
	setupUi(this);
	setApplyButton(ApplyButton);
	setDiscardButton(DiscardButton);

	//General
	addWidget("cn", Name, NoMulti, "^[0-9a-zA-Z][^+\\;,=]*$", "The name must not contain any of these characters (+ \\ ; , =).");
	addWidget("accountname", AccountName, NoMulti, "^[0-9a-zA-Z][^+\\;,=]*$", "The account name must not contain any of these characters (+ \\ ; , =).");
	addWidget("description", Description, NoMulti);

	//Contact tab
	addWidget("displayName", DisplayName, NoMulti);
	addWidget("street", Street);
	addWidget("city", City);
	addWidget("postalCode", Zip);
	addWidget("state", State);
	addWidget("country", Country);
	addWidget("homeNumber", HomeNumber, NoMulti);
	addWidget("email", Email);
	addWidget("office", Office);
	addWidget("department", Department);
	addWidget("aliases", Aliases, "list", SIGNAL(changed()));
	Aliases->setErrorText("You must specify a valid email address.");
	Aliases->setWeakValidator(QRegExp("[a-zA-Z0-9._%+-@]*"));
	Aliases->setStrongValidator(QRegExp("^[a-zA-Z0-9._%+-]*@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$"));
	Aliases->setUpDownArrows(false);
	
	//Countries
	addCountry("Afghanistan", "AF");
	addCountry("Albania", "AL");
	addCountry("Algeria", "DZ");
	addCountry("Andorra", "AD");
	addCountry("Angola", "AO");
	addCountry("Anguilla", "AI");
	addCountry("Antigua and Barbuda", "AG");
	addCountry("Argentina", "AR");
	addCountry("ARIPO", "AP");
	addCountry("Armenia", "AM");
	addCountry("Aruba", "AW");
	addCountry("Australia", "AU");
	addCountry("Austria", "AT");
	addCountry("Azerbaijan", "AZ");
	addCountry("Bahamas", "BS");
	addCountry("Bahrain", "BH");
	addCountry("Bangladesh", "BD");
	addCountry("Barbados", "BB");
	addCountry("BBM and BBDM", "BX");
	addCountry("Belarus", "BY");
	addCountry("Belgium", "BE");
	addCountry("Belize", "BZ");
	addCountry("Benin", "BJ");
	addCountry("Bermuda", "BM");
	addCountry("Bhutan", "BT");
	addCountry("Bolivia", "BO");
	addCountry("Bosnia and Herzegovina", "BA");
	addCountry("Botswana", "BW");
	addCountry("Bouvet Island", "BV");
	addCountry("Brazil", "BR");
	addCountry("British Virgin Islands", "VG");
	addCountry("Burundi", "BI");
	addCountry("Brunei Darussalam", "BN");
	addCountry("Bulgaria", "BG");
	addCountry("Burkina Faso", "BF");
	addCountry("Burma", "BU");
	addCountry("Cameroon", "CM");
	addCountry("Canada", "CA");
	addCountry("Cape Verde", "CV");
	addCountry("Cayman Islands", "KY");
	addCountry("Central African Republic", "CF");
	addCountry("Chad", "TD");
	addCountry("Chile", "CL");
	addCountry("China", "CN");
	addCountry("Colombia", "CO");
	addCountry("Comoros", "KM");
	addCountry("Congo", "CG");
	addCountry("Cook Islands", "CK");
	addCountry("Costa Rica", "CR");
	addCountry("Cote d'Ivoire", "CI");
	addCountry("Croatia", "HR");
	addCountry("Cuba", "CU");
	addCountry("Cyprus", "CY");
	addCountry("Czech Republic", "CZ");
	addCountry("Czechoslovakia", "CS");
	addCountry("Denmark", "DK");
	addCountry("Djibouti", "DJ");
	addCountry("Dominica", "DM");
	addCountry("Dominican Republic", "DO");
	addCountry("EAPO", "EA");
	addCountry("East Germany", "DD");
	addCountry("East Timor", "TP");
	addCountry("Ecuador", "EC");
	addCountry("Egypt", "EG");
	addCountry("El Salvador", "SV");
	addCountry("EPO", "EP");
	addCountry("Equatorial Guinea", "GQ");
	addCountry("Estonia", "EE");
	addCountry("Ethiopia", "ET");
	addCountry("Falkland Island", "FK");
	addCountry("Faroe Islands", "FO");
	addCountry("Fiji", "FJ");
	addCountry("Finland", "FI");
	addCountry("France", "FR");
	addCountry("Gabon", "GA");
	addCountry("Gambia", "GM");
	addCountry("Greenland", "GL");
	addCountry("Georgia", "GE");
	addCountry("Germany", "DE");
	addCountry("Ghana", "GH");
	addCountry("Gibraltar", "GI");
	addCountry("Greece", "GR");
	addCountry("Grenada", "GD");
	addCountry("Guatemala", "GT");
	addCountry("Guinea", "GN");
	addCountry("Guinea-Bissau", "GW");
	addCountry("Guyana", "GY");
	addCountry("Haiti", "HT");
	addCountry("Honduras", "HN");
	addCountry("Hong Kong", "HK");
	addCountry("Hungary", "HU");
	addCountry("Iceland", "IS");
	addCountry("IIB", "IB");
	addCountry("India", "IN");
	addCountry("Indonesia", "ID");
	addCountry("Iran", "IR");
	addCountry("Iraq", "IQ");
	addCountry("Ireland", "IE");
	addCountry("Israel", "IL");
	addCountry("Italy", "IT");
	addCountry("Jamaica", "JM");
	addCountry("Japan", "JP");
	addCountry("Jordan", "JO");
	addCountry("Kampuchea", "KH");
	addCountry("Kazakhstan", "KZ");
	addCountry("Kenya", "KE");
	addCountry("Kiribati", "KI");
	addCountry("Kuwait", "KW");
	addCountry("Kyrgyzstan", "KG");
	addCountry("Laos", "LA");
	addCountry("Lebanon", "LB");
	addCountry("Lesotho", "LS");
	addCountry("Liberia", "LR");
	addCountry("Libya", "LY");
	addCountry("Liechtenstein", "LI");
	addCountry("Lithuania", "LT");
	addCountry("Luxembourg", "LU");
	addCountry("Macao", "MO");
	addCountry("Macedonia", "MK");
	addCountry("Madagascar", "MG");
	addCountry("Malawi", "MW");
	addCountry("Malaysia", "MY");
	addCountry("Maldives", "MV");
	addCountry("Mali", "ML");
	addCountry("Malta", "MT");
	addCountry("Marshall Islands", "MH");
	addCountry("Mauritania", "MR");
	addCountry("Mauritius", "MU");
	addCountry("Mexico", "MX");
	addCountry("Micronesia", "FM");
	addCountry("Moldova", "MD");
	addCountry("Monaco", "MC");
	addCountry("Mongolia", "MN");
	addCountry("Montserrat", "MS");
	addCountry("Morocco", "MA");
	addCountry("Mozambique", "MZ");
	addCountry("Myanmar", "MM");
	addCountry("Namibia", "NA");
	addCountry("Nauru", "NR");
	addCountry("Nepal", "NP");
	addCountry("Netherlands(Holland)", "NL");
	addCountry("Netherlands Antilles", "AN");
	addCountry("New Zealand", "NZ");
	addCountry("Nicaragua", "NI");
	addCountry("Niger", "NE");
	addCountry("Nigeria", "NG");
	addCountry("North Korea", "KP");
	addCountry("Norway", "NO");
	addCountry("Northern Mariana Islands", "MP");
	addCountry("OAPI", "OA");
	addCountry("OHIM", "EM");
	addCountry("Oman", "OM");
	addCountry("Other Country", "XX");
	addCountry("Other Country in Africa", "X6");
	addCountry("Other Country in Asia", "X1");
	addCountry("Other Country in Europe", "X4");
	addCountry("Other Country in North America", "X2");
	addCountry("Other Country In Oceania", "X5");
	addCountry("Other Country in South America", "X3");
	addCountry("Pakistan", "PK");
	addCountry("Panama", "PA");
	addCountry("Papua New Guinea", "PG");
	addCountry("Paraguay", "PY");
	addCountry("Peru", "PE");
	addCountry("Philippines", "PH");
	addCountry("Poland", "PL");
	addCountry("Portugal", "PT");
	addCountry("Qatar", "QA");
	addCountry("Republic of Yemen", "YD");
	addCountry("Rhodesia", "RH");
	addCountry("Romania", "RO");
	addCountry("Russian Federation", "RU");
	addCountry("Rwanda", "RW");
	addCountry("Saint Helena", "SH");
	addCountry("Saint Kitts and Nevis", "KN");
	addCountry("Saint Lucia", "LC");
	addCountry("Saint Vincent and the Grenadines", "VC");
	addCountry("Samoa", "WS");
	addCountry("San Marino", "SM");
	addCountry("Sao Tome and Principe", "ST");
	addCountry("Saudi Arabia", "SA");
	addCountry("Senegal", "SN");
	addCountry("Seychelles", "SC");
	addCountry("Sierra Leone", "SL");
	addCountry("Singapore", "SG");
	addCountry("Slovakia", "SK");
	addCountry("Slovenia", "SI");
	addCountry("Solomon Islands", "SB");
	addCountry("Somalia", "SO");
	addCountry("South Africa", "ZA");
	addCountry("South Georgia and The South Sandwich Islands", "GS");
	addCountry("South Korea", "KR");
	addCountry("Spain", "ES");
	addCountry("Sri Lanka", "LK");
	addCountry("Sudan", "SD");
	addCountry("Suriname", "SR");
	addCountry("Swaziland", "SZ");
	addCountry("Sweden", "SE");
	addCountry("Switzerland", "CH");
	addCountry("Syria", "SY");
	addCountry("Taiwan", "TW");
	addCountry("Tajikistan", "TJ");
	addCountry("Tanzania", "TZ");
	addCountry("Thailand", "TH");
	addCountry("Togo", "TG");
	addCountry("Tonga", "TO");
	addCountry("Trinidad and Tobago", "TT");
	addCountry("Tunisia", "TN");
	addCountry("Turkey", "TR");
	addCountry("Turkmenistan", "TM");
	addCountry("Turks and Caicos Islands", "TC");
	addCountry("Tuvalu", "TV");
	addCountry("Uganda", "UG");
	addCountry("Ukraine", "UA");
	addCountry("United Arab Emirates", "AE");
	addCountry("United Kingdom", "GB");
	addCountry("United States of America", "US");
	addCountry("Uruguay", "UY");
	addCountry("Soviet Union", "SU");
	addCountry("Uzbekistan", "UZ");
	addCountry("Vanuatu", "VU");
	addCountry("Vatican City", "VA");
	addCountry("Venezuela", "VE");
	addCountry("Vietnam", "VN");
	addCountry("Volta", "HV");
	addCountry("Western Sahara", "EH");
	addCountry("WIPO", "WO");
	addCountry("Yemen", "YE");
	addCountry("Yugoslavia", "YU");
	addCountry("Zaire", "ZR");
	addCountry("Zambia", "ZM");
	addCountry("Zimbabwe", "ZW");
	
	//Members
	addWidget("members", MemberList, "members", SIGNAL(changed()), NoMulti, QStringList());

	//Member Of
	addWidget("groups", GroupList, "groups", SIGNAL(changed()), NoMulti, QStringList());

	QObject::connect(manager, SIGNAL(entityRenamed(QString, QString)), this, SLOT(entityRenamed(QString, QString)));
}

GroupEditWidget::~GroupEditWidget()
{
}

#define GET_DATA(name,function) ret = function; \
	if(ret.isError() && !ret.errString().endsWith("attribute does not exist")) err = ret; \
	fields[name] = ret

ReturnValue GroupEditWidget::getData()
{
	QVariantMap fields;
	
	if (input() == "") return(ReturnValue(1, "Invalid Group"));
	
	RdsGroup group(input());

	ReturnValue err = true;
	ReturnValue ret;

	GET_DATA("cn", group.cn());
	GET_DATA("accountname", group.accountName());
	GET_DATA("description", group.description());
	GET_DATA("groups", group.groups());
	
	GET_DATA("displayName", group.displayName());
	GET_DATA("office", group.office());
	GET_DATA("phoneNumber", group.phoneNumber());
	GET_DATA("email", group.email());
	GET_DATA("aliases", group.emailAliases());
	GET_DATA("street", group.street());
	fields["street"] = fields["street"].toString().replace("\r", ""); //remove \r from \r\n
	GET_DATA("city", group.city());
	GET_DATA("state", group.state());
	GET_DATA("country", group.country());
	QString country = fields["country"].toString();
	if (_abbrtocountry.keys().contains(country)) fields["country"] = _abbrtocountry[country];
	GET_DATA("postalCode", group.postalCode());
	GET_DATA("homeNumber", group.homeNumber());
	GET_DATA("department", group.department());
	GET_DATA("company", group.company());
	
	GET_DATA("members", group.members());
	QStringList tmp = fields["members"].toStringList();
	tmp.sort();
	fields["members"] = tmp;

	if (err.isError())
	{
		QMessageBox msg(QMessageBox::Warning, "Error", "There was an error opening this OU: " + ret.errString(), QMessageBox::Ok);
		QAbstractButton *editbutton = msg.addButton("Edit Anyway", QMessageBox::RejectRole);
		msg.exec();
		if (msg.clickedButton() == editbutton)
		{
			if (QMessageBox::warning(this, "Warning", "Editing a OU in this state may be dangerous. Continue?", QMessageBox::Yes | QMessageBox::No, QMessageBox::No) == QMessageBox::Yes)
			{
				return(fields);
			}
		}
		return(err);
	}


	return(fields);
}

#define SET_FIELD(field,function) if (name == field) \
	{ \
		ret = function; \
		if (ret.isError()) err = ret; \
	}

#define SET_FIELD_STRING(field,function) \
	SET_FIELD(field,group.function(value.toString()));
	
#define SET_FIELD_STRINGLIST(field,function) \
	SET_FIELD(field,group.function(value.toStringList()));

bool GroupEditWidget::setData(QString id, QVariantMap fields)
{
	RdsGroup group(id);

	ReturnValue err = true;
	ReturnValue ret;

	QString cn = group.cn().toString();
	
	
	foreach(QString name, fields.keys())
	{
		QVariant value = fields[name];

		SET_FIELD_STRING("accountname", setAccountName);
		SET_FIELD_STRING("description", setDescription);

		SET_FIELD_STRING("displayName", setDisplayName);
		SET_FIELD_STRING("street", setStreet);
		SET_FIELD_STRING("city", setCity);
		SET_FIELD_STRING("postalCode", setPostalCode);
		SET_FIELD_STRING("state", setState);
		SET_FIELD_STRING("homeNumber", setHomeNumber);
		SET_FIELD_STRING("office", setOffice);
		SET_FIELD_STRING("department", setDepartment);
		
		if (name == "email")
		{
			QString email = value.toString();
			email = email.replace("%GROUPNAME%", cn);
			email = email.replace("%USERNAME%", cn);
			if(email.startsWith("@")) email = cn + email;
			email = email.replace(" ","_");
			ret = group.setEmail(email);
			if (ret.isError()) err = ret;
		}
		
		if (name == "aliases")
		{
			QStringList aliases;
			
			foreach(QString email, value.toStringList())
			{
				email = email.replace("%GROUPNAME%",cn);
				email = email.replace("%USERNAME%",cn);
				if(email.startsWith("@")) email = cn + email;
				email = email.replace(" ","_");
				
				aliases << email;
			}
			
			ret = group.setEmailAliases(aliases);
			if (ret.isError()) err = ret;
		}
		
		if (name == "country")
		{
			if (_countrytoabbr.contains(value.toString()))
			{
				value = _countrytoabbr[value.toString()];
			}
			//qDebug() << "setting country" << value;
			ret = group.setCountry(value.toString());
			if (ret.isError()) err = ret;
		}
		
		if (name == "groups")
		{
			//qDebug() << "Changing Groups:" << value.toStringList();
			ret = group.groups();
			if (!ret.isError())
			{
				QStringList newgroups = value.toStringList();
				QStringList oldgroups = ret.toStringList();
				
				//Add new groups
				foreach(QString g, newgroups)
				{
					if (!oldgroups.contains(g))
					{
						ret = group.joinGroup(g);
						//qDebug() << "Joining Group:" << g;
						if (ret.isError()) err = ret;
					}
				}

				foreach(QString g, oldgroups)
				{
					if (!newgroups.contains(g))
					{
						ret = group.leaveGroup(g);
						//qDebug() << "Leaving Group:" << g;

						if (ret.isError()) err = ret;
					}
				}
			}
			else
			{
				err = ret;
			}

		}

		if (name == "members")
		{
			//qDebug() << "Changing members:" << value.toStringList();
			ret = group.members();
			if (!ret.isError())
			{
				QStringList newmembers = value.toStringList();
				QStringList oldmembers = ret.toStringList();

				//Add new groups
				foreach(QString m, newmembers)
				{
					if (!oldmembers.contains(m))
					{
						ret = group.addMember(m);
						//qDebug() << "Adding Member:" << m;
						if (ret.isError()) err = ret;
					}
				}

				foreach(QString m, oldmembers)
				{
					if (!newmembers.contains(m))
					{
						ret = group.removeMember(m);
						//qDebug() << "Removing Member:" << m;

						if (ret.isError()) err = ret;
					}
				}
			}
			else
			{
				err = ret;
			}

		}

		if (name == "cn")
		{
			//qDebug() << "setting cn" << value;
			ret = group.setCn(value.toString());
			if (ret.isError())
			{
				err = ret;
			}
			else
			{
				QString dn = ret.toString();

				QStringList outlist = outputs();
				for (int i = 0; i < outlist.size(); i++)
				{
					if (outlist[i] == id) outlist[i] = dn;
				}

				setInput(dn);
				setOutputs(outlist);

				manager()->renameEntity(id, dn);
			}
		}
	}

	if (err.isError())
	{
		qWarning() << "Failed to save group:" << id << err.errString();
		return(false);
	}
	else return(true);
}

void GroupEditWidget::entityUpdated(QString id)
{
	if (id != input()) return;

	if (unsavedChanges())
	{
		if (QMessageBox::question(this, "Group Changed",
		                          "Another user has made changes to the item you are editing. Would you like to overwrite your changes?",
		                          QMessageBox::Yes | QMessageBox::No, QMessageBox::No) == QMessageBox::Yes)
		{
			RdsEntityWidget::entityUpdated(id);
		}
	}
	else
	{
		RdsEntityWidget::entityUpdated(id);
	}
}

void GroupEditWidget::entityRenamed(QString oldid, QString newid)
{
	if (oldid != input()) return;

	RdsGroup group(newid);
	ReturnValue ret = group.cn();
	if (ret.isError()) return;

	QString cn = ret.toString();

	QStringList outlist = outputs();
	for (int i = 0; i < outlist.size(); i++)
	{
		if (outlist[i] == input()) outlist[i] = newid;
	}

	setInput(newid);
	setOutputs(outlist);

	setField("cn", cn);
}

void GroupEditWidget::setInput(QString input)
{
	RdsEntityWidget::setInput(input);
	MemberList->setDn(input);
}

void GroupEditWidget::addCountry(QString name, QString abbr)
{
	_countrytoabbr[name] = abbr;
	_abbrtocountry[abbr] = name;
	Country->addItem(name);
}
