/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "freespacedelegate.h"
#include <QModelIndex>
#include <QPainter>
#include <QBrush>
#include <QStyle>
#include <QStyleOptionProgressBar>
#include <RdsEntityModel>


FreeSpaceDelegate::FreeSpaceDelegate(QSortFilterProxyModel *sort, QObject *parent)
		: QItemDelegate(parent)
{
	_sort = sort;
}


FreeSpaceDelegate::~FreeSpaceDelegate()
{
}

void FreeSpaceDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
	QModelIndex newindex = _sort->mapToSource(index);
	RdsEntityModel::Cache *cache = (RdsEntityModel::Cache *)newindex.internalPointer();
	if ((cache != NULL) && newindex.isValid())
	{
		if (option.state & QStyle::State_Selected)
			painter->fillRect(option.rect, option.palette.highlight());

		bool mounted = false;
		if (cache->metadata().contains("mounted")) mounted = cache->metadata()["mounted"].toBool();

		if ((cache->metadata().contains("status")) && (cache->metadata()["status"].toString().toLower() == "disconnected"))
		{
			QItemDelegate::paint(painter, option, index);
			return;
		}

		qlonglong size = 0, free = 0;
		if (cache->metadata().contains("size")) size = cache->metadata()["size"].toLongLong();
		if (cache->metadata().contains("free")) free = cache->metadata()["free"].toLongLong();
		qlonglong used = size - free;

		int progress = ((float)used / (float)size) * 100;
		QString text = QString("%1 Free").arg(index.data().toString());

		QStyleOptionProgressBar op;
		op.initFrom((QWidget *)parent());

		if (!mounted)
		{
			progress = 0;
			text = "Unavailable";
		}

		op.rect = option.rect;
		op.rect.setHeight(op.rect.height());
		op.rect.setY(op.rect.y());
		op.rect.setWidth(op.rect.width() - 10);
		op.rect.setX(op.rect.x() + 5);
		op.minimum = 0;
		op.maximum = 100;
		op.progress = progress;
		op.text = text;
		QStyle *style = ((QWidget *)parent())->style();
		if (mounted) style->drawControl(QStyle::CE_ProgressBarGroove, &op, painter, ((QWidget *)parent()));
		if (mounted) style->drawControl(QStyle::CE_ProgressBarContents, &op, painter, ((QWidget *)parent()));
		style->drawControl(QStyle::CE_ProgressBarLabel, &op, painter, ((QWidget *)parent()));
	}
	else
	{
		QItemDelegate::paint(painter, option, index);
	}

}
