/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef DNSRECORDEDITWIDGET_H
#define DNSRECORDEDITWIDGET_H

#include <QWidget>
#include "rdsentitywidget.h"
#include "ui_dnsrecordeditwidget.h"
#include <RdsDnsManager>
#include <RdsDnsZone>

class DnsRecordEditWidget : public RdsEntityWidget, private Ui::DnsRecordEditWidget
{
	Q_OBJECT;
public:
	DnsRecordEditWidget(RdsDnsManager *manager, QWidget* parent = 0);
	~DnsRecordEditWidget();

protected slots:
	void entityRenamed(QString oldid, QString newid);

protected:
	ReturnValue getData();
	bool setData(QString id, QVariantMap fields);
	bool endSetData();
	void entityUpdated(QString id);
	bool validate();

private:
	RdsDnsZone *_zone;
	QString _newname;
	int _newid;
};

#endif
