/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef DATETIMEWIDGET_H
#define DATETIMEWIDGET_H

#include <QWidget>
#include "ui_datetimewidget.h"
#include <QDateTime>
#include <ReturnValue>

class DateTimeWidget : public QWidget, private Ui::DateTimeWidget
{
	Q_OBJECT

public:
	DateTimeWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~DateTimeWidget();

protected slots:
	void updateTime();
	void on_DateEdit_editingFinished();
	void on_TimeEdit_editingFinished();
	void on_ApplyButton_clicked();
	void on_DiscardButton_clicked();
	void on_TimeZoneChooser_activated(QString timezone);
	void setDateReturned(uint id, ReturnValue ret);
	void setTimeZoneReturned(uint id, ReturnValue ret);
	
private:
	void update();
	QDateTime _datetime;
	QString _datetext;
	QString _timetext;
	bool _datetimeedited;
	QString _timezone;
};

#endif

