/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "computeripwidget.h"
#include <QMessageBox>
#include <QDebug>
#include <QRegExp>
#include <QRegExpValidator>
#include "config.h"

#define IP_VALIDATOR QRegExp("^([0-9]{0,3}\\.){0,3}[0-9]{0,3}$")

ComputerIpWidget::ComputerIpWidget(QWidget* parent, Qt::WFlags fl)
		: QWidget(parent, fl), Ui::ComputerIpWidget()
{
	setupUi(this);

	IpEdit->setValidator(new QRegExpValidator(IP_VALIDATOR, this));

	QObject::connect(IpEdit, SIGNAL(textEdited(QString)), this, SIGNAL(changed()));
	QObject::connect(DynamicCheck, SIGNAL(toggled(bool)), this, SIGNAL(changed()));
}

ComputerIpWidget::~ComputerIpWidget()
{
}

QString ComputerIpWidget::ip()
{
	if(DynamicCheck->isChecked()) return("");
	else return(IpEdit->text());
}

void ComputerIpWidget::setIp(const QString& ip)
{
	if(ip == "")
	{
		DynamicCheck->setChecked(true);
		IpEdit->setText("");
	}
	else
	{
		StaticCheck->setChecked(true);
		IpEdit->setText(ip);
	}
}

