/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef BROWSEDIALOG_H
#define BROWSEDIALOG_H

#include <QDialog>
#include "ui_browsedialog.h"
#include <RdsFileManager>
#include "rdsfilemodel.h"
#include "rdsfilesortmodel.h"

class BrowseDialog : public QDialog, private Ui::BrowseDialog
{
	Q_OBJECT

public:
	enum BrowseType
	{
		All = 0xFFFF,
		Volumes = 1 << 0,
  		Shares = 1 << 1,
    		FileSystem = 1 << 2
	};
	Q_DECLARE_FLAGS(BrowseTypes, BrowseType);
	
	BrowseDialog(BrowseTypes flags, QWidget* parent = 0, Qt::WFlags fl = 0);
	~BrowseDialog();

	QString path();
	
public slots:
	virtual void accept();
	
protected slots:
	void on_NewButton_clicked();
	void newfolder(uint id, ReturnValue ret);
	void showFileSystem(bool show);
	void contextMenu(const QPoint& point);

private:
	RdsFileModel *_model;
	RdsFileSortModel *_sort;
	RdsFileManager *_manager;
	QItemSelectionModel *_selection;
	QAction *_newfolder;
	QAction *_showfilesystem;
};

Q_DECLARE_OPERATORS_FOR_FLAGS(BrowseDialog::BrowseTypes);

#endif

