/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef ADDRECORDDIALOG_H
#define ADDRECORDDIALOG_H

#include <QDialog>
#include "ui_addrecorddialog.h"
#include <ReturnValue>
#include <RdsDnsManager>

class AddRecordDialog : public QDialog, private Ui::AddRecordDialog
{
	Q_OBJECT

public:
	AddRecordDialog(QString zone, QString origin, RdsDnsManager *manager, QWidget* parent = 0, Qt::WFlags fl = 0);
	~AddRecordDialog();

protected slots:
	void accept();

private:
	RdsDnsManager *_manager;
	QString _origin;
	QString _zone;
};

#endif

