/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "config.h"
#include "addrecorddialog.h"
#include "rdsdnsmodel.h"
#include <RdsUtils>
#include <QMessageBox>
#include <QDebug>
#include <QRegExpValidator>
#include <RdsDaemonManager>
#include <RdsDnsZone>
#include <RdsDnsRecord>
#include <RdsClient>
#include <rdsprovisionator.h>

AddRecordDialog::AddRecordDialog(QString zone, QString origin, RdsDnsManager* manager, QWidget* parent, Qt::WFlags fl)
		: QDialog(parent, fl), Ui::AddRecordDialog()
{
	setupUi(this);
	_manager = manager;
	_origin = origin;
	_zone = zone;

	if (_origin == _zone) _origin = "";

	NameEdit->setValidator(new QRegExpValidator(QRegExp("^[a-zA-Z0-9][a-zA-Z0-9_.-]+[a-zA-Z0-9]$"), this));

	for (int i = 1; true; ++i)
	{
		QString t = RdsDnsZone::typeToString((RdsDnsZone::RecordType)i);
		if (t.isEmpty())
			break;
		TypeBox->addItem(t, i);
	}

}


AddRecordDialog::~AddRecordDialog()
{
}

void AddRecordDialog::accept()
{
	QString name;

	if (_origin == "")
	{
		if (NameEdit->text() == "")
		{
			name = "IN";
		}
		else if (NameEdit->text().toLower() == _zone.toLower())
		{
			name = "IN";
		}
		else if (NameEdit->text().toLower() + "." == _zone.toLower())
		{
			name = "IN";
		}
		else
		{
			name = NameEdit->text();
		}
	}
	else
	{
		if (NameEdit->text() == "")
		{
			QMessageBox::critical(this, "Error", "You must specify a name for the new record.");
			return;
		}
		else
		{
			name = NameEdit->text();
		}
	}

	if (!RdsDnsModel::validateRecord(ValueEdit->text(), RdsDnsZone::stringToType(TypeBox->currentText())))
	{
		return;
	}

	ReturnValue ret = _manager->zone(_zone);
	if (ret.isError())
	{
		QMessageBox::critical(this, "Error", "Failed fetch domain: " + ret.errString());
		return;
	}

	RdsDnsZone zone = ret;

	RdsDnsRecord record;
	record.setType(RdsDnsZone::stringToType(TypeBox->currentText()));
	record.setKey(name);
	record.setOrigin(_origin);
	record.setValue(ValueEdit->text());

	//qDebug() << _origin << name << "became" << record.origin() << record.key();

	ret = zone.addRecord(record);
	if (ret.isError())
	{
		QMessageBox::critical(this, "Error", "Failed to add the name server record: " + ret.errString());
		return;
	}

	ret = zone.save();
	if (ret.isError())
	{
		QMessageBox::critical(this, "Error", "Failed to save zone file: " + ret.errString());
		return;
	}

	_manager->addEntity(record.id(_zone));

	RdsDaemonManager mgr;
	ret = mgr.init();

	if (ret.isError())
	{
		QMessageBox::critical(this, "Error", "Failed to get RdsDaemonManager service: " + ret.errString());
		QDialog::accept();
		return;
	}

	ret = mgr.reloadService("Dns");

	if (ret.isError())
	{
		QMessageBox::critical(this, "Error", "Failed to restart the DNS server: " + ret.errString());
		QDialog::accept();
		return;
	}

	//if we get here, everything worked
	QDialog::accept();
}
