/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "aceflagswidget.h"
#include <config.h>

AceFlagsWidget::AceFlagsWidget(QWidget* parent, Qt::WFlags fl)
		: QWidget(parent, fl), Ui::AceFlagsWidget()
{
	setupUi(this);
}


AceFlagsWidget::~AceFlagsWidget()
{
}

RdsAce::Flags AceFlagsWidget::flags()
{
	RdsAce::Flags f  = 0;

	switch (FlagsCombo->currentIndex())
	{
		case 0:
			f = RdsAce::FileInherit | RdsAce::FolderInherit;
			break;
		case 1:
			f = RdsAce::FileInherit;
			break;
		case 2:
			f = RdsAce::FolderInherit;
			break;
		case 3:
			f = RdsAce::NoPropogate;
			break;
		case 4:
			f = RdsAce::InheritOnly | RdsAce::FileInherit | RdsAce::FolderInherit;
			break;
		case 5:
			f = RdsAce::InheritOnly | RdsAce::FileInherit;
			break;
		case 6:
			f = RdsAce::InheritOnly | RdsAce::FolderInherit;
			break;
	}

	return(f);
}
