/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsldapsession.h"
#include "rdsldapsession_p.h"
#include <ReturnValue>
#include <QDebug>
#include <QStringList>
#include <QRegExp>
#include "config.h"

QTRPC_REGISTER_METATYPE(LdapResults);
QTRPC_REGISTER_METATYPE(LdapResult);
QTRPC_REGISTER_METATYPE(LdapValues);

using namespace QtRpc;

QPointer<RdsLdapSession> RdsLdapSessionPrivate::globalsession;

RdsLdapSession::RdsLdapSession(QObject *parent)
		: ClientProxy(parent)
{
	QXT_INIT_PRIVATE(RdsLdapSession);

	if (qxt_d().globalsession == NULL)
	{
		qxt_d().globalsession = this;
	}
}

RdsLdapSession::~RdsLdapSession()
{

}

RdsLdapSession *RdsLdapSession::globalSession()
{
	if (RdsLdapSessionPrivate::globalsession == NULL)
	{
		qFatal("The global LDAP object was used without being initialized!");
		return(NULL);
	}

	return(RdsLdapSessionPrivate::globalsession);
}

void RdsLdapSession::setGlobalSession(RdsLdapSession *session)
{
	RdsLdapSessionPrivate::globalsession = session;
}

