/***************************************************************************
 *   Copyright (C) 2009 by Brendan Powers   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RDSJOB_H
#define RDSJOB_H

#include <ClientProxy>
#include <QxtPimpl>
#include <rdsglobal.h>
#include <QStringList>
#include <RdsSchedule>

class RdsJobPrivate;

/**
@author Chris Vickery <chris@resara.com>
 */
class RDS_CLIENT_EXPORT RdsJob : public QtRpc::ClientProxy
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsJob);
	QTRPC_CLIENTPROXY_PIMPL(RdsJob);
public:
	RdsJob(QObject *parent = 0);
	RdsJob(const RdsJob &other);
	~RdsJob();

	RdsJob &operator=(const RdsJob &other);

	enum Status
	{
		Stopped,
		Running,
		Paused,
		Finished,
		Failed
	};

	enum LogLevel
	{
		Info,
		Warning,
		Error
	};

	struct LogEntry
	{
		QString log;
		RdsJob::LogLevel level;
		QDateTime timestamp;
	};

signals:
	ReturnValue name() const;
	ReturnValue description() const;
	ReturnValue status() const;
	ReturnValue progress() const;
	ReturnValue progressText() const;
	ReturnValue progressDetails() const;
	ReturnValue getLog() const;
	ReturnValue getLog(QObject *obj, const char *slot) const;
	ReturnValue canPause() const;
	ReturnValue id() const;

	ReturnValue start();
	ReturnValue stop();
	ReturnValue pause();
	ReturnValue resume();

	ReturnValue setName(const QString& name);
	ReturnValue setDescription(const QString& desc);
	ReturnValue registerJob();

	QtRpc::Event progressChanged(int percent, const QString& progressText, const QString& progressDetails);
	QtRpc::Event statusChanged(RdsJob::Status status);
	QtRpc::Event newLogMessages(const QList<RdsJob::LogEntry> &logs);
	QtRpc::Event finished(const ReturnValue& ret);
};

QDataStream& operator<<(QDataStream& d, const RdsJob::LogEntry& log);
QDataStream& operator>>(QDataStream& d, RdsJob::LogEntry& log);
QDataStream& operator<<(QDataStream& d, const RdsJob::LogLevel& log);
QDataStream& operator>>(QDataStream& d, RdsJob::LogLevel& log);
QDataStream& operator<<(QDataStream& d, const RdsJob::Status& log);
QDataStream& operator>>(QDataStream& d, RdsJob::Status& log);

Q_DECLARE_METATYPE(RdsJob::LogLevel);
QTRPC_REGISTER_METATYPE(RdsJob::LogLevel);

Q_DECLARE_METATYPE(RdsJob::LogEntry);
QTRPC_REGISTER_METATYPE(RdsJob::LogEntry);
Q_DECLARE_METATYPE(QList<RdsJob::LogEntry>);
QTRPC_REGISTER_METATYPE(QList<RdsJob::LogEntry>);

Q_DECLARE_METATYPE(RdsJob::Status);
QTRPC_REGISTER_METATYPE(RdsJob::Status);

#endif
