/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
***************************************************************************/
#ifndef RDSDHCPVALUES_H
#define RDSDHCPVALUES_H

#include <ClientProxy>
#include <QxtPimpl>
#include <rdsglobal.h>
#include <QStringList>

class RdsDhcpValuesPrivate;

using namespace QtRpc;

/**
@author Brendan Powers <brendan@resara.com>
*/
class RDS_CLIENT_EXPORT RdsDhcpValues : public ClientProxy
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsDhcpValues);
	QTRPC_CLIENTPROXY_PIMPL(RdsDhcpValues);
public:
	RdsDhcpValues(QObject *parent = 0);
	RdsDhcpValues(const RdsDhcpValues &other);
	~RdsDhcpValues();

	RdsDhcpValues &operator=(const RdsDhcpValues &other);

signals:
        ReturnValue values() const;
        ReturnValue setValues(const QVariantMap &map);
        ReturnValue value(const QString &key) const;
        ReturnValue setValue(const QString &key, const QString &value);
        ReturnValue valueExists(const QString &key);
        ReturnValue removeValue(const QString &key);
        ReturnValue options() const;
        ReturnValue setOptions(const QVariantMap &map);
        ReturnValue option(const QString &key) const;
        ReturnValue setOption(const QString &key, const QString &value);
        ReturnValue optionExists(const QString &key);
        ReturnValue removeOption(const QString &key);
        ReturnValue groups() const;
        ReturnValue subnets() const;
        ReturnValue sharedNetworks() const;
        ReturnValue hosts() const;
        ReturnValue sharedNetwork(const QString &sharedNetwork) const;
        ReturnValue host(const QString &hostname) const;
        ReturnValue group(const QString &group) const;
        ReturnValue subnet(const QString &subnet) const;
        ReturnValue addSharedNetwork(const QString &sharedNetwork);
        ReturnValue addHost(const QString &hostname);
        ReturnValue addGroup(const QString &group);
        ReturnValue addSubnet(const QString &subnet);
        ReturnValue removeSharedNetwork(const QString &sharedNetwork);
        ReturnValue removeHost(const QString &hostname);
        ReturnValue removeGroup(const QString &group);
        ReturnValue removeSubnet(const QString &subnet);

	//These functions are not actually a part of the RdsDhcpValues object.
	//However, every subclass except for the manager implements them.
	//USE WITH CARE
	ReturnValue name();
	ReturnValue setName(const QString &name);
};

#endif
