/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
***************************************************************************/
#ifndef RDSDHCPSUBNET_H
#define RDSDHCPSUBNET_H

#include <RdsDhcpValues>
#include <QxtPimpl>
#include <rdsglobal.h>
#include <QStringList>
#include <QHostAddress>

class RdsDhcpSubnetPrivate;

using namespace QtRpc;

/**
@author Brendan Powers <brendan@resara.com>
*/
class RDS_CLIENT_EXPORT RdsDhcpSubnet : public RdsDhcpValues
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsDhcpSubnet);
	QTRPC_CLIENTPROXY_PIMPL(RdsDhcpSubnet);
public:
	typedef QPair<QHostAddress, QHostAddress> Range;
	typedef QList<Range> RangeList;


	RdsDhcpSubnet(QObject *parent = 0);
	RdsDhcpSubnet(const RdsDhcpSubnet &other);
	~RdsDhcpSubnet();

	RdsDhcpSubnet &operator=(const RdsDhcpSubnet &other);
	ReturnValue setRanges(const RangeList &ranges);

signals:
	ReturnValue name() const;
	ReturnValue setName(const QString &name);
	ReturnValue address() const;
	ReturnValue setAddress(const QHostAddress &addr);
	ReturnValue netmask() const;
	ReturnValue setNetmask(const QHostAddress &addr);
	ReturnValue ranges() const;
	ReturnValue setRanges(const QVariant &ranges);
};

QTRPC_REGISTER_METATYPE(RdsDhcpSubnet::Range);
QTRPC_REGISTER_METATYPE(RdsDhcpSubnet::RangeList);
QTRPC_REGISTER_METATYPE(QHostAddress);
Q_DECLARE_METATYPE(RdsDhcpSubnet::Range);
Q_DECLARE_METATYPE(RdsDhcpSubnet::RangeList);
Q_DECLARE_METATYPE(QHostAddress);

#endif
