/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSCLIENT_P_H
#define RDSCLIENT_P_H

#include <QxtPimpl>
#include <QMutex>
#include "rdsclient.h"

class RdsClientPrivate : public QxtPrivate<RdsClient>
{
public:
	RdsClientPrivate()
			: signalMutex(QMutex::Recursive)
	{
	}

	struct ConnectionObject
	{
		ConnectionObject() : object(0){ }
		QObject* object;
		QString slot;
	};
	static RdsClient *instance;
	static QStringList serverprotocolversions;
	QMutex signalMutex; //used for return signals
	QHash <uint, ConnectionObject> connectionObjects;
};

#endif
