# Copyright (C)        2010 John Chambers, Dirk Eddelbuettel and Romain Francois
#
# This file is part of Rcpp.
#
# Rcpp is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Rcpp is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rcpp.  If not, see <http://www.gnu.org/licenses/>.

populate <- function( module, env ){
    
    # make sure the module is loaded
    module <- Module( module, mustStart = TRUE )
    
    storage <- get( "storage", as.environment(module ) )
    symbols <- ls( storage )
    
    is_ns <- isNamespace( env )
    for( x in symbols ){
        if( is_ns && exists( x, env ) && bindingIsLocked(x, env ) ){
            unlockBinding( x, env )
        }
        
        assign( x, storage[[x]], env )
        
        if( is_ns ){
            lockBinding( x, env )
        }
    }
}

