/******************************************************************************
*		       							      *
* rcalc.c (part of rcalc)					       	      *
* Copyright (C) 2001 Free Software Foundation, Inc.			      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef RCALC_TEXT_ONLY
 #include "main.h"		/* rcalc's GNOME user interface		*/
#else
 #include <popt.h>
 #include <glib.h>
 #include <libintl.h>
 #define N_(String) gettext (String)
 #define EXIT_SUCCESS 1
#endif

#include "console_main.h"	/* rcalc's text-based user interface	*/
#include <engine/debug.h>	/* Debugging functions	     		*/

#include <errno.h>

/*****************************************************************************/

int main( int argc, char *argv[] )
{
	/* Command line options.
	*/
	gint gnomeui = 0;	/* Use the GNOME UI (default).		     */
	gint textui  = 0;	/* Use the terminal-based text UI.	     */
#ifdef EXPRUI
	gchar *evalexpr = NULL;	/* Evaluate the supplied expression.	     */
	gchar *evalfile = NULL;	/* Read the file and evaluate it.	     */ 
#endif
	
	gint debug_engine  = 0;	/* Show engine debugging messages.	     */
	gint debug_gnomeui = 0;	/* Show GNOME UI debugging messages.	     */
	gint debug	   = 0;	/* Show all debugging messages.		     */

#ifndef RCALC_TEXT_ONLY
	const struct poptOption options[] =
	{
		{ "gnome", 'g',
		  POPT_ARG_NONE, &gnomeui, 0,
		  /* Command Options | --gnome */
		  N_( "Use the GNOME UI (default)." ), NULL },

		{ "text", 't',
		  POPT_ARG_NONE, &textui, 0,
		  /* Command Options | --text  */
		  N_( "Use the terminal-based text UI." ), NULL },
#ifdef EXPRUI
		{ "expression", 'e',
		  POPT_ARG_STRING, &evalexpr, 0,
		  /* Command Options | --expression  */
		  N_( "Evaluate an expression." ),
		  /* Command Options | Argument to --expression */
		  N_( "EXPRESSION" ) },

		{ "file", 'f',
		  POPT_ARG_STRING, &evalfile, 0,
		  /* Command Options | --file  */
		  N_( "Evaluate the expressions in a file." ),
		  /* Command Options | Argument to --file */
		  N_( "FILE" ) },
#endif /* ifdef EXPRUI */
		{ "debug-gnomeui", '\0',
		  POPT_ARG_NONE, &debug_gnomeui, 0,
		  /* Command Options | --debug-engine */
		  N_( "Show GNOME UI debugging messages." ), NULL },

		{ "debug-engine", '\0',
		  POPT_ARG_NONE, &debug_engine, 0,
		  /* Command Options | --debug-engine */
		  N_( "Show calculation engine debugging messages." ), NULL },

		{ "debug", '\0',
		  POPT_ARG_NONE, &debug, 0,
		  /* Command Options | --debug */
		  N_( "Show all debugging messages." ), NULL },

		{ NULL, '\0', 0, NULL, 0 }
	};
	poptContext ctx;
	int popt_code;
	
#endif /* ifndef RCALC_TEXT_ONLY */	

	/* Wake up NLS
	*/
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
   textdomain (GETTEXT_PACKAGE);
	
	/* Scan for command line options. This is done here (as
	** opposed to, say, within gnome_init_with_popt_table()
	** because we do not wish to run gnome_init() unless we are
	** using the GNOME UI.
	**
	** No error reporting is done here; if we detect an error we
	** force the GNOME UI which will complain for us when it runs
	** gnome_init_with_popt_table().
	*/

#ifndef RCALC_TEXT_ONLY
	ctx = poptGetContext( PACKAGE, argc, (const char **)argv, options, 0 );

	while(( popt_code = poptGetNextOpt( ctx ) ) != -1 )
	{
		if( popt_code >= 0 ) continue;
		
		if( popt_code == POPT_ERROR_ERRNO )
		{
			/* A system call returned with an error within popt.
			*/
			g_error( "poptGetNextOpt(): failed due to: %s.",
				 g_strerror( errno ) );
		}
		else
		{
			/* There was a problem with the command-line
			** options. Force the GNOME UI.
			*/
			gnomeui = 1;
		}
	}
	poptFreeContext( ctx );
	
	/* Wake up GNOME. */
	/* This is also needed for the gnome2-based text-ui,
	 for config files and so on.
	 Non-gnome2 text, ui, however doesn't need this */
	 
	gnome_program_init(PACKAGE, VERSION, LIBGNOMEUI_MODULE,
	                            argc, argv, GNOME_PARAM_POPT_TABLE, options,
										 GNOME_PARAM_APP_DATADIR,PACKAGE_DATA_DIR,
										 NULL);
	

#else
	textui = 1;
	gnomeui = 0;
#endif /* ifndef RCALC_TEXT_ONLY */	

	/* Process the non-UI-selecting command line options.
	*/
	if( debug_gnomeui ) rc_debug_add_state( RC_DBG_GNOMEUI );
	if( debug_engine  ) rc_debug_add_state( RC_DBG_ENGINE );
	if( debug 	  ) rc_debug_add_state( RC_DBG_TOPLEVEL );

	/* Execute the required user interface.
	*/

#ifndef RCALC_TEXT_ONLY
	if( gnomeui )
		rc_gnome_main( argc, argv, options );
#ifdef EXPRUI
	else if( evalexpr || evalfile )
		rc_expr_main( evalexpr, evalfile );
#endif	
	/*else if( textui )
		rc_console_main();*/
	else
		rc_gnome_main( argc, argv, options );
#else
	/*rc_console_main();*/
#endif

	exit( EXIT_SUCCESS );
}

/*** end of rcalc.c **********************************************************/
