/******************************************************************************
*		       							      *
* engine/output.c (part of rcalc)				       	      *
* Copyright (C) 2000, 2001 Free Software Foundation, Inc.		      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <engine.h>
#include <output.h>		/* This file's header	     		*/

#include <stdio.h>
#include <stdarg.h>

#include <glib.h>

#ifndef RCALC_TEXT_ONLY
 #include <gnome.h>
#else
 #include <libintl.h>
 #define _(String) gettext (String)
#endif

/*****************************************************************************/

/* Settings
*/
static	FILE			*rc_stdout = NULL;
static	FILE			*rc_stderr = NULL;
static	RcDisplayHelpFunc	 rc_help   = NULL;

/*****************************************************************************/

/* Manipulate settings.
*/
void rc_output_set_streams( FILE *output, FILE *error )
{
	rc_stdout = output;
	rc_stderr = error;
}
void rc_output_set_help_func( RcDisplayHelpFunc func )
{
	g_assert( func );
	rc_help = func;
}

/*****************************************************************************/

/* Ugly horrible LUT for the helptopics. TODO: make less hardwired somehow.
*/
#define NUM_TOPICS	32

#if 0
static gchar *topics_lut[NUM_TOPICS][2] =
{
	{ "exit",	"#cmd_exit"		},
	{ "quit",	"#cmd_exit"		},
	{ "help",	"#cmd_help"		},
	{ "helpwin",	"#cmd_help"		},
	{ "?",		"#cmd_help"		},
	{ "man",	"#cmd_help"		},
	{ "ls",		"#cmd_ls"		},
	{ "who",	"#cmd_ls"		},
	{ "rm",		"#cmd_rm"		},
	{ "clear",	"#cmd_rm"		},
	{ "mode",	"#cmd_mode"		},
	{ "deg",	"#cmd_mode"		},
	{ "rad",	"#cmd_mode"		},
	{ "int",	"#fun_int"		},
	{ "abs",	"#fun_abs"		},
	{ "ln",		"#fun_logs"		},
	{ "log",	"#fun_logs"		},
	{ "sqrt",	"#fun_sqrt"		},
	{ "sin",	"#fun_trig"		},
	{ "cos",	"#fun_trig"		},
	{ "tan",	"#fun_trig"		},
	{ "asin",	"#fun_trig"		},
	{ "acos",	"#fun_trig"		},
	{ "atan",	"#fun_trig"		},
	{ "sinh",	"#fun_hype"		},
	{ "cosh",	"#fun_hype"		},
	{ "tanh",	"#fun_hype"		},
	{ "asinh",	"#fun_hype"		},
	{ "acosh",	"#fun_hype"		},
	{ "atanh",	"#fun_hype"		},
	{ "pi",		"#constants"		},
	{ "e",		"#constants"		},
};
#endif

/* Display help
*/
gboolean rc_display_help( const gchar *topic )
{
#if 0
	gchar *anchor = NULL;
	int i;
/*	gchar *path=NULL;*/
	GError *err;
	err = NULL;

	if( !rc_help ) rc_error(_("help is not available with this UI."));
	
	/* Determine position within the file.
	*/
	if( !topic ) anchor = "";
	for( i=0; i<NUM_TOPICS && !anchor; i++ )
	{
		if( !strcasecmp( topic, topics_lut[i][0] ) )
		{
			anchor = topics_lut[i][1];
		}
	}
	if( !anchor ) return FALSE;

	/* Build the URL and load it.
	*/
/*	path = g_strdup_printf( "index.html%s", anchor );*/

	rc_help( "index.html", anchor, &err );

	if (err) {
	  printf(_("There was an error displaying help: %s"),err->message);
	}
/*	g_free( path );*/
	
#endif
	return TRUE;
}

/*****************************************************************************/

/* Various different colours.
*/
#define DEFAULTCOLOUR	"\x1B[0m"
#define ERRORCOLOUR	"\x1B[0;31m"

/* Formatted printing.
*/
void rc_printf( const gchar *format, ... )
{
	va_list args;

/*	if( !rc_stdout ) rc_stdout = stdout; */
  if ( rc_stdout ) {
	
	  va_start( args, format );
	  vfprintf( rc_stdout, g_locale_from_utf8(format,-1,NULL,NULL,NULL), args );
	  va_end( args );

	  fflush( rc_stdout );
  }
}
void rc_error( gchar err_reason, const gchar *format, ... )
{
	va_list args;
	gchar *err_string;

/*	if( !rc_stderr ) rc_stderr = stdout; */
  if( rc_stderr ) {

	  /* Output | Prefix for all error messages */
	  fprintf( rc_stderr, "%s%s ", ERRORCOLOUR, _("error:") );
  }
  
	va_start( args, format );
  if( rc_stderr ) {
	  vfprintf( rc_stderr, g_locale_from_utf8(format,-1,NULL,NULL,NULL), args );
	}
  g_vasprintf ( &err_string, g_locale_from_utf8(format,-1,NULL,NULL,NULL), args );
	va_end( args );
	
	rc_export_error (err_reason, err_string);
	g_free(err_string);

  if( rc_stderr ) {
	  fprintf( rc_stderr, "%s\n", DEFAULTCOLOUR );
	  fflush( rc_stderr );
  }
}

/*** end of engine/output.c **************************************************/
