/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>
#include <string.h>
#include <gnome.h>
#include <panel-applet.h>
#include <gdk/gdkkeysyms.h>

#include "rcalc_applet.h"
#include "command_line.h"
#include "preferences.h"
#include "exec.h"

static gboolean
button_press_cb (GtkEntry   *entry,
		 GdkEventKey *event,
		 MCData      *mc)
{
    const gchar *str;
    if (mc->error) { 
	   mc->error = FALSE; 
	   str = gtk_editable_get_chars (GTK_EDITABLE (entry), 0, -1);
	   gtk_entry_set_text (entry, (gchar *) str + 3);
	}
    return FALSE;
}

static gboolean
command_key_event (GtkEntry   *entry,
		   GdkEventKey *event,
		   MCData      *mc)
{
    guint key = event->keyval;
    char *command;
    static char current_command[MC_MAX_COMMAND_LENGTH];
    gboolean propagate_event = TRUE;
    const gchar *str;

    if (mc->error) { 
	   mc->error = FALSE; 
	   str = gtk_editable_get_chars (GTK_EDITABLE (entry), 0, -1);
	   gtk_entry_set_text (entry, (gchar *) str + 3);
	   gtk_editable_set_position (GTK_EDITABLE (entry), strlen (str));
	}

    if(key == GDK_Return
	    || key == GDK_KP_Enter
	    || key == GDK_ISO_Enter
	    || key == GDK_3270_Enter)
	{
	    /* enter pressed -> exec command */
	    command = (char *) malloc(sizeof(char) * MC_MAX_COMMAND_LENGTH);
	    strcpy(command, (char *) gtk_entry_get_text(entry));
	    rca_exec_command(mc, command);

	    free(command);

	    strcpy(current_command, "");
	    propagate_event = FALSE;
	}
    
    return !propagate_event;
}

void
rca_create_command_entry (MCData *mc)
{
    mc->history = gtk_list_store_new (1, G_TYPE_STRING);
    mc->comboboxentry = gtk_combo_box_entry_new_with_model (GTK_TREE_MODEL(mc->history),
    0);
    GTK_WIDGET_SET_FLAGS (mc->comboboxentry, GTK_CAN_FOCUS);
    mc->entry = GTK_BIN (mc->comboboxentry)->child;
    gtk_entry_set_max_length(GTK_ENTRY(mc->entry), MC_MAX_COMMAND_LENGTH);
    
    /*mc->entry = gtk_entry_new_with_max_length (MC_MAX_COMMAND_LENGTH); */
    
    g_signal_connect (mc->entry, "key_press_event",
		      G_CALLBACK (command_key_event), mc);
   
    g_signal_connect (mc->entry, "button_press_event",
		      G_CALLBACK (button_press_cb), mc);

    rca_command_update_entry_size (mc);

    set_atk_name_description (mc->entry,
			      _("rcalc command line"), 
			      _("Type a rcalc expression here and it will calculate it for you"));
}

void
rca_command_update_entry_size (MCData *mc)
{
    int size_x = -1;
    
    size_x = mc->preferences.normal_size_x - 17;
    if ((mc->orient == PANEL_APPLET_ORIENT_LEFT) || (mc->orient == PANEL_APPLET_ORIENT_RIGHT)) {
      size_x = MIN(size_x, mc->preferences.panel_size_x - 17);
      gtk_widget_set_size_request (GTK_WIDGET (mc->entry), size_x, -1);
    } else {
      gtk_widget_set_size_request (GTK_WIDGET (mc->entry), size_x, mc->preferences.normal_size_y+2);
    }
}


