#ifndef INCLUDED_langs_h
#define INCLUDED_langs_h

struct lconn;
struct client;

/* The maximum number of languages we can support.  Note, if a user is
 * marked as using a translation that no longer exists, it will still count
 * towards this limit.
 */
#define LANG_MAX 32


/* DO NOT CHANGE LANG_DEFAULT.
 *
 * This macro is only used to define a "fallback" language that is
 * guaranteed to be complete.  It will only be used when a translated
 * version of the helpfile we are looking for is not around.  If this
 * language is not complete, services will likely crash.
 *
 * There is a conf option to set a default language, use that instead.
 */
#define LANG_DEFAULT "en"

extern const char *langs_available[];

void init_langs(void);

void lang_load_trans(void);
void lang_clear_trans(void);

unsigned int lang_get_langcode(const char *name);

struct cachefile *lang_get_cachefile(struct cachefile **, struct client *);
struct cachefile *lang_get_cachefile_u(struct cachefile **, struct lconn *);

/* langs_format.c */
int lang_fmt_check(const char *filename, const char *original, const char *translation);

/* when changing this, you MUST reflect the change in svc_notice_string in
 * langs.c and add a default into messages.c
 */
enum svc_notice_enum
{
	/* general service */
	SVC_UNKNOWNCOMMAND,
	SVC_SUCCESSFUL,
	SVC_SUCCESSFULON,
	SVC_ISSUED,
	SVC_NEEDMOREPARAMS,
	SVC_ISDISABLED,
	SVC_ISDISABLEDEMAIL,
	SVC_NOTSUPPORTED,
	SVC_NOACCESS,
	SVC_OPTIONINVALID,
	SVC_RATELIMITEDGENERIC,
	SVC_RATELIMITED,
	SVC_RATELIMITEDHOST,
	SVC_NOTLOGGEDIN,
	SVC_ENDOFLIST,
	SVC_ENDOFLISTLIMIT,
	SVC_USECOMMANDSHORTCUT,
	SVC_INVALIDMASK,

	/* general irc related */
	SVC_IRC_NOSUCHCHANNEL,
	SVC_IRC_CHANNELINVALID,
	SVC_IRC_CHANNELNOUSERS,
	SVC_IRC_NOSUCHSERVER,
	SVC_IRC_SERVERNAMEINVALID,
	SVC_IRC_ALREADYONCHANNEL,
	SVC_IRC_YOUALREADYONCHANNEL,
	SVC_IRC_NOTINCHANNEL,
	SVC_IRC_YOUNOTINCHANNEL,
	SVC_IRC_NOTOPPEDONCHANNEL,

	/* email */
	SVC_EMAIL_INVALID,
	SVC_EMAIL_INVALIDIGNORED,
	SVC_EMAIL_BANNEDDOMAIN,
	SVC_EMAIL_TEMPUNAVAILABLE,
	SVC_EMAIL_SENDFAILED,

	/* service help */
	SVC_HELP_INDEXINFO,
	SVC_HELP_TOPICS,
	SVC_HELP_UNAVAILABLE,
	SVC_HELP_UNAVAILABLETOPIC,
	SVC_HELP_INDEXADMIN,

	/* userserv */
	SVC_USER_USERLOGGEDIN,
	SVC_USER_REGISTERDISABLED,
	SVC_USER_ALREADYREG,
	SVC_USER_NOTREG,
	SVC_USER_NOWREG,
	SVC_USER_NOWREGLOGGEDIN,
	SVC_USER_NOWREGEMAILED,
	SVC_USER_REGDROPPED,
	SVC_USER_INVALIDUSERNAME,
	SVC_USER_INVALIDPASSWORD,
	SVC_USER_INVALIDLANGUAGE,
	SVC_USER_LONGPASSWORD,
	SVC_USER_LOGINSUSPENDED,
	SVC_USER_LOGINUNACTIVATED,
	SVC_USER_LOGINMAX,
	SVC_USER_ALREADYLOGGEDIN,
	SVC_USER_NICKNOTLOGGEDIN,
	SVC_USER_SUSPENDED,
	SVC_USER_NOEMAIL,
	SVC_USER_CHANGEDPASSWORD,
	SVC_USER_CHANGEDOPTION,
	SVC_USER_QUERYOPTION,
	SVC_USER_QUERYOPTIONALREADY,
	SVC_USER_REQUESTISSUED,
	SVC_USER_REQUESTPENDING,
	SVC_USER_REQUESTNONE,
	SVC_USER_TOKENBAD,
	SVC_USER_TOKENMISMATCH,
	SVC_USER_DURATIONTOOSHORT,
	SVC_USER_NOACCESSON,
	/* userserv::activate */
	SVC_USER_ACT_ALREADY,
	SVC_USER_ACT_COMPLETE,
	/* userserv::resetpass */
	SVC_USER_RP_LOGGEDIN,
	/* userserv::userlist */
	SVC_USER_UL_START,

	/* userserv::info */
	/* chanserv::info */
	/* nickserv::info */
	SVC_INFO_REGDURATIONUSER,
	SVC_INFO_REGDURATIONCHAN,
	SVC_INFO_REGDURATIONNICK,
	SVC_INFO_SUSPENDED,
	SVC_INFO_SUSPENDEDADMIN,
	SVC_INFO_ACCESSLIST,
	SVC_INFO_NICKNAMES,
	SVC_INFO_EMAIL,
	SVC_INFO_URL,
	SVC_INFO_TOPIC,
	SVC_INFO_SETTINGS,
	SVC_INFO_ENFORCEDMODES,
	SVC_INFO_CURRENTLOGON,

	/* nickserv */
	SVC_NICK_NOTONLINE,
	SVC_NICK_ALREADYREG,
	SVC_NICK_NOTREG,
	SVC_NICK_NOWREG,
	SVC_NICK_CANTREGUID,
	SVC_NICK_USING,
	SVC_NICK_TOOMANYREG,
	SVC_NICK_LOGINFIRST,
	SVC_NICK_REGGEDOTHER,
	SVC_NICK_CHANGEDOPTION,
	SVC_NICK_QUERYOPTION,

	/* chanserv */
	SVC_CHAN_NOWREG,
	SVC_CHAN_NOTREG,
	SVC_CHAN_ALREADYREG,
	SVC_CHAN_CHANGEDOPTION,
	SVC_CHAN_UNSETOPTION,
	SVC_CHAN_QUERYOPTION,
	SVC_CHAN_QUERYOPTIONALREADY,
	SVC_CHAN_LISTSTART,
	SVC_CHAN_ISSUSPENDED,
	SVC_CHAN_NOACCESS,
	SVC_CHAN_USERNOACCESS,
	SVC_CHAN_USERALREADYACCESS,
	SVC_CHAN_USERHIGHERACCESS,
	SVC_CHAN_INVALIDACCESS,
	SVC_CHAN_INVALIDAUTOLEVEL,
	SVC_CHAN_INVALIDSUSPENDLEVEL,
	SVC_CHAN_USERSETACCESS,
	SVC_CHAN_USERREMOVED,
	SVC_CHAN_USERSETAUTOLEVEL,
	SVC_CHAN_USERSETSUSPEND,
	SVC_CHAN_USERSUSPENDREMOVED,
	SVC_CHAN_USERHIGHERSUSPEND,
	SVC_CHAN_REQUESTPENDING,
	SVC_CHAN_REQUESTNONE,
	SVC_CHAN_TOKENMISMATCH,
	SVC_CHAN_NOMODE,
	SVC_CHAN_INVALIDMODE,
	SVC_CHAN_ALREADYOPPED,
	SVC_CHAN_ALREADYVOICED,
	SVC_CHAN_YOUNOTBANNED,
	SVC_CHAN_USEDELOWNER,
	SVC_CHAN_BANSET,
	SVC_CHAN_BANREMOVED,
	SVC_CHAN_ALREADYBANNED,
	SVC_CHAN_NOTBANNED,
	SVC_CHAN_BANLISTFULL,
	SVC_CHAN_INVALIDBAN,
	SVC_CHAN_BANHIGHERLEVEL,
	SVC_CHAN_BANHIGHERACCOUNT,
	SVC_CHAN_BANLISTSTART,

	/* operserv */
	SVC_OPER_CONNECTIONSSTART,
	SVC_OPER_CONNECTIONSEND,
	SVC_OPER_SERVERNAMEMISMATCH,
	SVC_OPER_OSPARTACCESS,
	SVC_OPER_IGNORENOTFOUND,
	SVC_OPER_IGNOREALREADY,
	SVC_OPER_IGNORELIST,

	/* banserv */
	SVC_BAN_ISSUED,
	SVC_BAN_ALREADYPLACED,
	SVC_BAN_NOTPLACED,
	SVC_BAN_INVALID,
	SVC_BAN_LISTSTART,
	SVC_BAN_NOPERMACCESS,
	SVC_BAN_REGEXPSUCCESS,
	SVC_BAN_TOOMANYMATCHES,
	SVC_BAN_TOOMANYREGEXPMATCHES,

	/* global */
	SVC_GLOBAL_WELCOMETOOLONG,
	SVC_GLOBAL_WELCOMEINVALID,
	SVC_GLOBAL_WELCOMESET,
	SVC_GLOBAL_WELCOMENOTSET,
	SVC_GLOBAL_WELCOMEDELETED,
	SVC_GLOBAL_WELCOMELIST,

	/* jupeserv */
	SVC_JUPE_ALREADYJUPED,
	SVC_JUPE_NOTJUPED,
	SVC_JUPE_ALREADYREQUESTED,
	SVC_JUPE_PENDINGLIST,

	/* alis */
	SVC_ALIS_LISTSTART,

	/* memoserv */
	SVC_MEMO_RECEIVED,
	SVC_MEMO_SENT,
	SVC_MEMO_TOOMANYMEMOS,
	SVC_MEMO_INVALID,
	SVC_MEMO_DELETED,
	SVC_MEMO_DELETEDALL,
	SVC_MEMO_LIST,
	SVC_MEMO_LISTSTART,
	SVC_MEMO_READ,

	/* this must be last */
	SVC_LAST
} svc_notice_id;

/* contains the string version of the enum above */
extern const char *svc_notice_string[];

/* name of translations */
extern char *langs_description[];

extern const char **svc_notice[];

const char *lang_get_notice(enum svc_notice_enum msgid, struct client *, struct lconn *);

/* used to create the 'default' hardcoded language from messages.c */
struct _lang_internal
{
	enum svc_notice_enum id;
	const char *msg;
};

extern struct _lang_internal lang_internal[];

#endif
