/*
  rakarrack - a guitar effects software

 Compressor.h  -  Compressor Effect definitions
 Based on artscompressor.cc by Matthias Kretz <kretz@kde.org>
 Stefan Westerfeld <stefan@space.twc.de> 
 
  Copyright (C) 2008 Daniel Vidal & Josep Andreu
  Author: Daniel Vidal & Josep Andreu

 This program is free software; you can redistribute it and/or modify
 it under the terms of version 2 of the GNU General Public License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License (version 2) for more details.

 You should have received a copy of the GNU General Public License
 (version2)  along with this program; if not, write to the Free Software
 Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/


#ifndef COMPRESSOR_H
#define COMPRESSOR_H

#include "global.h"

#define REALTYPE float
#define LN2                       (0.6931471805599453094172321214581765680755)
#define MUG_CORR_FACT  0.4



class Compressor
{

public:

  Compressor (REALTYPE * efxoutl_, REALTYPE * efxoutr_);
  ~Compressor ();

  void out (REALTYPE * smps_l, REALTYPE * smps_r);

  void Compressor_Change (int np, int value);
  void Compressor_Change_Preset (int npreset);
  int getpar (int npar);
  void cleanup ();

  REALTYPE *efxoutl;
  REALTYPE *efxoutr;



  // Compressor

  int tatt;			// attack time  (ms)
  int trel;			// release time (ms)
  int tratio;
  int toutput;
  int tthreshold;
  int a_out;
  int knee;

private:

  float volume;
  float volume_db;
  float threshold;		// threshold
  float knee_max;
  float knee_min;
  float ratio;			// ratio
  float output;
  float att;
  float rel;
  float gain;
  float gain_old;

  float compress ();


};

#endif
