% File src/library/base/man/cat.Rd
% Part of the R package, http://www.R-project.org
% Copyright 1995-2007 R Core Development Team
% Distributed under GPL 2 or later

\name{cat}
\title{Concatenate and Print}
\usage{
cat(\dots , file = "", sep = " ", fill = FALSE, labels = NULL,
    append = FALSE)
}
\alias{cat}
\description{
  Outputs the objects, concatenating the representations.  \code{cat}
  performs much less conversion than \code{\link{print}}.
}
\arguments{
  \item{\dots}{\R objects (see \sQuote{Details} for the types of objects allowed).}
  \item{file}{A connection, or a character string naming the file
    to print to.  If \code{""} (the default), \code{cat} prints to the
    standard output connection, the console unless redirected by
    \code{\link{sink}}.
#ifdef unix
    If it is \code{"|cmd"}, the output is piped to the command given
    by \file{cmd}, by opening a pipe connection.
#endif
  }
  \item{sep}{a character vector of strings to append after each element.}
  \item{fill}{a logical or (positive) numeric controlling how the output is
    broken into successive lines.  If \code{FALSE} (default), only newlines
    created explicitly by \samp{"\\n"} are printed.  Otherwise, the
    output is broken into lines with print width equal to the option
    \code{width} if \code{fill} is \code{TRUE}, or the value of
    \code{fill} if this is numeric.  Non-positive \code{fill} values are
    ignored, with a warning.}
  \item{labels}{character vector of labels for the lines printed.
    Ignored if \code{fill} is \code{FALSE}.}
  \item{append}{logical. Only used if the argument \code{file} is the
    name of file (and not a connection or \code{"|cmd"}).
    If \code{TRUE} output will be appended to
    \code{file}; otherwise, it will overwrite the contents of
    \code{file}.}
}
\details{
  \code{cat} is useful for producing output in user-defined functions.
  It converts its arguments to character vectors, concatenates
  them to a single character vector, appends the given \code{sep=}
  string(s) to each element and then outputs them.

  No linefeeds are output unless explicitly requested by \samp{"\\n"}
  or if generated by filling (if argument \code{fill} is \code{TRUE} or
  numeric.)

  If \code{file} is a connection and open for writing it is written from
  its current position.  If it is not open, it is opened for the
  duration of the call in \code{"wt"} mode and then closed again.

  Currently only atomic vectors (and so not lists) and \link{name}s
  are handled.  Character strings are output \sQuote{as is} (unlike
  \code{\link{print.default}} which escapes non-printable characters and
  backslash --- use \code{\link{encodeString}} if you want to output
  encoded strings using \code{cat}).  Other types of \R object should be
  converted (e.g. by \code{\link{as.character}} or \code{\link{format}})
  before being passed to \code{cat}.

  \code{cat} converts numeric/complex elements in the same way as
  \code{print} (and not in the same way as \code{\link{as.character}}
  which is used by the S equivalent), so \code{\link{options}}
  \code{"digits"} and \code{"scipen"} are relevant.  However, it uses
  the minimum field width necessary for each element, rather than the
  same field width for all elements.
}
\note{
  If any element of \code{sep} contains a newline character, it is
  treated as a vector of terminators rather than separators, an element
  being output after every vector element \emph{and} a newline after the
  last.  Entries are recycled as needed.
}
\value{
  None (invisible \code{NULL}).
}
\references{
  Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth & Brooks/Cole.
}
\seealso{
  \code{\link{print}}, \code{\link{format}}, and \code{\link{paste}}
  which concatenates into a string.
}
\examples{
iter <- stats::rpois(1, lambda=10)
## print an informative message
cat("iteration = ", iter <- iter + 1, "\n")

## 'fill' and label lines:
cat(paste(letters, 100* 1:26), fill = TRUE,
    labels = paste("{",1:10,"}:",sep=""))
}
\keyword{print}
\keyword{file}
\keyword{connection}
