<CsoundSynthesizer>

; Id: B00_a.CSD mg (2006, rev.2009)
; author: marco gasperini (marcogsp at yahoo dot it)

; G.M. Koenig
; ESSAY (1957)

<CsOptions>
-W -f -oB00_a.wav
</CsOptions>

<CsInstruments>

sr     = 192000
kr     = 19200
ksmps  = 10
nchnls = 1

;=============================================
; SINUS TONES
;=============================================
	instr 1	
iamp	= ampdb(87+p4)
ifreq	= p5

a1	oscili iamp , ifreq , 1
aenv	linen 1 , .01 , p3 , .01

aout	= a1 * aenv

	out aout
	endin
;=============================================

;=============================================
; FILTERED NOISE
;=============================================
	instr 2
iamp	= ampdb(87+p4)
ifreq	= p5
ibw	= ifreq * .05		; filtered noise's bandwidth 5% of central frequency

a1	rnd31 iamp , 1 
k1	rms a1

afilt	butterbp a1 , ifreq , ibw
afilt	butterbp afilt , ifreq , ibw

aenv	linen .9,  .01 , p3 , .01

aout	gain afilt , k1
aout	= aout * aenv 

	out aout
	endin
;=============================================

;=============================================
; FILTERED IMPULSES
;=============================================
	instr 3
iamp	= ampdb(87+p4)
ifreq	= p5
ibw	= ifreq * .01		; filtered pulse's bandwidth 1% of central frequency

if1	= ifreq-(ibw/3)
if2	= ifreq+((2*ibw)/3)

				
a1	mpulse iamp , 0 
k1	rms a1

afilt	atonex a1 , if1 , 2
afilt	tonex afilt*580 , if2 , 2
afilt	butterbp afilt*600 , ifreq , ibw *.5

aenv	linseg 1 , p3-.01, 1 , .01 , 0

aout	= afilt * aenv 

	out aout
	endin
;=============================================
</CsInstruments>
<CsScore>
;functions--------------------------------------------------
f1	0	8192	10	1	; sinusoid
;/functions--------------------------------------------------

t0	4572	; 76.2 cm/sec. tape speed (durations in cm)

;test--------------------------------------------------
;mute-------------------------------------------------
q 1 0 1
q 3 0 1
;/mute-------------------------------------------------
;/test-------------------------------------------------

;====================================================
; 120. MATERIAL B
; 121. total length: 256.5 cm, 6 sections
;
; sequence a
;
; length   sequence 	
; 27.8  cm (3)
; 93.7  cm (6)
; 41.7  cm (4)
; 12.3  cm (1)
; 18.5  cm (2)
; 62.5  cm (5)
;==================================================

;==================================121.11
; 27.8 cm ratio 10/9
;----------------------------------
;			p4	p5
;			iamp	ifreq	timbre
;			[dB]	[Hz]	
i1	0	3.2	0	84	; S
i3	3.2	2.9	-3.5	102     ; I
i1	6.1	4.9	0	124     ; S
i3	11	3.9	-7	151     ; I
i1	14.9	3.6	0	183     ; S
i3	18.5	2.3	-10	223     ; I
i1	20.8	4.4	0	271     ; S
i3	25.2	2.6	-13.5	329     ; I
s                                   
t0	4572	
;==================================121.12
; 93.7 cm ratio 7/6
;----------------------------------------
; x
i1	0	8.7	-6	161	; S
i1	+	7.5	-6	156	; S
i1	+	16.2	-6	141	; S
i1	+	11.9	-6	172	; S
i1	+	10.2	-6	166	; S	
i1	+	18.9	-6	146	; S
i1	+	13.9	-6	178     ; S
i1	+	6.4	-6	151     ; S
; y                                 
i3	0	6.4	-11.5	137	; I
i3	+	13.9	-11	128     ; I
i3	+	18.9	-10.5	120     ; I
i3	+	10.2	-10	113     ; I
i3	+	11.9	-9.5	109     ; I
i3	+	16.2	-10.5	116     ; I
i3	+	7.5	-11	124     ; I
i3	+	8.7	-11.5	133     ; I
s                                   
t0	4572	
;==================================121.13
; 41.7 cm ratio 9/8
;----------------------------------------
; x
i3	0	7.6	-18.5	309	; I
i3	+	6.8	-16.5	238     ; I
i3	+	4.7	-14	183	; I
i3	+	3.8	-12	141     ; I
i3	+	3.3	-9.5	109     ; I
i3	+	5.3	-7.5	84      ; I
i3	+	4.2	-5.3	65      ; I
i3	+	6	-3	50      ; I
; y                                 
i1	0	6	-6	50	; S
i1	+	4.2	-6	65      ; S
i1	+	5.3	-6	84	; S
i1	+	3.3	-6	109     ; S
i1	+	3.8	-6	141     ; S
i1	+	4.7	-6	183     ; S
i1	+	6.8	-6	238     ; S
i1	+	7.6	-6	309     ; S
s                                   
t0	4572	
;==================================121.14
; 12.3 cm ratio 12/11
;----------------------------------------
; x
i1	0	1.4	-6	96	; S
i1	+	1.1	-6	93      ; S
i1	+	1.3	-6	84      ; S
i1	+	1.9	-6	102     ; S
i1	+	2.1	-6	99      ; S
i1	+	1.2	-6	87      ; S
i1	+	1.6	-6	106     ; S
i1	+	1.7	-6	90      ; S
; y                                     
i3	0	1.7	-9.5	109     ; I
i3	+	1.6	-10.5	124     ; I
i3	+	1.2	-10.5	141     ; I
i3	+	2.1	-13	161     ; I
i3	+	1.9	-13.5	172     ; I
i3	+	1.3	-12.5	151     ; I
i3	+	1.1	-9.5	133     ; I
i3	+	1.4	-10	116     ; I
s                                   
t0	4572	
;==================================121.15
; 18.5 cm ratio 11/10
;----------------------------------------
i1	0	2.4	0	202	; I
i3	2.4	2.1	-13.5	172	; S
i1	4.5	1.6	0	146	; I
i3	6.1	2.9	-11	124	; S
i1	9	2.6	0	106	; I
i3	11.6	1.8	-8	90	; S	
i1	13.4	3.2	0	76	; I
i3	16.6	1.9	-5	65	; S
s                                   
t0	4572	
;==================================121.16
; 62.5 cm ratio 8/7
;----------------------------------------
; x
i1	0	4.7	-6	183	; S
i1	+	11.9	-6	172     ; S
i1	+	8	-6	141     ; S
i1	+	6.1	-6	209     ; S
i1	+	5.3	-6	196     ; S
i1	+	9.1	-6	151     ; S
i1	+	7	-6	223     ; S
i1	+	10.4	-6	161     ; S
; y                                     
i3	0	10.4	-7.5	84      ; I
i3	+	7	-8.5	96      ; I
i3	+	9.1	-9.5	109     ; I
i3	+	5.3	-11	124     ; I
i3	+	6.1	-11.5	133     ; I
i3	+	8	-10.5	116     ; I
i3	+	11.9	-9	102     ; I
i3	+	4.7	-8	90      ; I
                                    
; total length: 256.5 cm
e

</CsScore>
</CsoundSynthesizer>