/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "QuteComBuildId.h"

#include <cutil/global.h>
#include <util/String.h>

#include <curl/curl.h>
#if !defined(OS_MACOSX) && defined(OWSOUND_PORTAUDIO_SUPPORT)
	#include <portaudio.h>
#endif
#include <boost/version.hpp>
#include <tinyxml.h>
extern "C" {
#include <avcodec.h>
#if defined (IMWRAPPER_BACKEND_MULTI)
	#include <glib.h>
	#include <libpurple/core.h>
#endif
}

#define stringize2(x) #x
#define stringize(x) stringize2(x)

const unsigned long long QuteComBuildId::getBuildId() {
	return DD_BUILDID;
}

const char * QuteComBuildId::getVersion() {
	return stringize(DD_VERSION);
}

const char * QuteComBuildId::getSvnRevision() {
	return stringize(DD_REVISION);
}

const char * QuteComBuildId::getSoftphoneName() {
	return stringize(DD_SOFTPHONE_NAME);
}

const char * QuteComBuildId::getBoostVersion() {
	static std::string version(BOOST_LIB_VERSION);
	return version.c_str();
}

const char * QuteComBuildId::getPurpleVersion() {
#if defined (IMWRAPPER_BACKEND_MULTI)
	return purple_core_get_version();
#endif
	return "";
}

const char * QuteComBuildId::getGLibVersion() {
#if defined (IMWRAPPER_BACKEND_MULTI)
	static std::string version(String::fromNumber(GLIB_MAJOR_VERSION) + "." +
		String::fromNumber(GLIB_MINOR_VERSION) + "." +
		String::fromNumber(GLIB_MICRO_VERSION));
	return version.c_str();
#endif
	return "";
}

const char * QuteComBuildId::getCurlVersion() {
	return curl_version();
}

const char * QuteComBuildId::getPortaudioVersion() {
#if !defined(OS_MACOSX) && defined(OWSOUND_PORTAUDIO_SUPPORT)
	return Pa_GetVersionText();
#endif
	return "";
}

const char * QuteComBuildId::getAvcodecVersion() {
	static std::string version(String::fromNumber(avcodec_version()));
	return version.c_str();
}

const char * QuteComBuildId::getTinyXmlVersion() {
	static std::string version(String::fromNumber(TIXML_MAJOR_VERSION) + "." +
		String::fromNumber(TIXML_MINOR_VERSION) + "." +
		String::fromNumber(TIXML_PATCH_VERSION));
	return version.c_str();
}
