/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OWQTTREEVIEWDELEGATE_H
#define OWQTTREEVIEWDELEGATE_H

#include <QtCore/QSize>
#include <QtGui/QItemDelegate>
#include <QtGui/QPixmap>

class CQuteCom;
class QAbstractItemModel;
class QModelIndex;
class QPainter;
class QRect;
class QStyleOptionViewItem;
class QWidget;
class QtContactManager;
class QtUserWidget;

/**
 * Qt Presentation component for ContactList.
 *
 * @author Mr K
 */
class QtTreeViewDelegate : public QItemDelegate {
	Q_OBJECT
public:

	QtTreeViewDelegate(CQuteCom & cQuteCom,
		QtContactManager * qtContactManager, QObject * parent = 0);

	QWidget * createEditor(QWidget * parent, const QStyleOptionViewItem & option, const QModelIndex & index) const;

	void setEditorData(QWidget * editor, const QModelIndex & index) const;

	void setModelData(QWidget * editor, QAbstractItemModel * model, const QModelIndex & index) const;

	void paint(QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index) const;

	void setParent(QWidget * parent);

	QSize sizeHint(const QStyleOptionViewItem & option, const QModelIndex & index) const;

private:

	void drawGroup(QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index) const;

	QPixmap getGroupBackGround(const QRect & rect) const;

	const QWidget * _parent;

	QPixmap _menuIcon;

	mutable QPixmap _groupBackground;

	QtContactManager * _qtContactManager;

	CQuteCom & _cQuteCom;
};

#endif	//OWQTTREEVIEWDELEGATE_H
