/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "PhoneCallState.h"

#include <model/config/ConfigManager.h>
#include <model/config/Config.h>

#include <sound/Sound.h>

#include <util/Logger.h>

Sound * PhoneCallState::_sound = NULL;
static RecursiveMutex _mutexSound;

PhoneCallState::PhoneCallState() {
}

void PhoneCallState::stopSound() {
	RecursiveMutex::ScopedLock scopedLock(_mutexSound);
	if (_sound) {
		_sound->stop();
		delete _sound;
		_sound = NULL;
	}
}

void PhoneCallState::playSoundIncomingCall() {
	RecursiveMutex::ScopedLock scopedLock(_mutexSound);
	Config & config = ConfigManager::getInstance().getCurrentConfig();
	stopSound();

	if (config.getAudioRingingEnable())
	{
		_sound = new Sound(config.getAudioIncomingCallFile());
		_sound->setWaveOutDevice(getRingerAudioDevice());
		_sound->setLoops(-1);
		_sound->play();	
	}
}

void PhoneCallState::playSoundOutgoingCall() {
	RecursiveMutex::ScopedLock scopedLock(_mutexSound);
	Config & config = ConfigManager::getInstance().getCurrentConfig();

	stopSound();
	if (config.getAudioRingingEnable())
	{
		_sound = new Sound(config.getAudioOutgoingCallFile());
		_sound->setWaveOutDevice(getRingerAudioDevice());
		_sound->setLoops(-1);
		_sound->play();
	}
}

void PhoneCallState::playSoundDoubleCall() {
	RecursiveMutex::ScopedLock scopedLock(_mutexSound);
	Config & config = ConfigManager::getInstance().getCurrentConfig();

	stopSound();
	if (config.getAudioRingingEnable())
	{
		_sound = new Sound(config.getAudioDoubleCallFile());
		_sound->setWaveOutDevice(getRingerAudioDevice());
		_sound->setLoops(1);
		_sound->play();
	}
}

void PhoneCallState::playSoundCallClosed() {
	RecursiveMutex::ScopedLock scopedLock(_mutexSound);
	Config & config = ConfigManager::getInstance().getCurrentConfig();

	stopSound();
	if (config.getAudioRingingEnable())
	{
		_sound = new Sound(config.getAudioCallClosedFile());
		_sound->setWaveOutDevice(getRingerAudioDevice());
		_sound->setLoops(4);
		_sound->play();
	}
}

AudioDevice PhoneCallState::getRingerAudioDevice() {
	Config & config = ConfigManager::getInstance().getCurrentConfig();
	return AudioDevice(config.getAudioRingerDeviceId());
}
