/***************************************************************************
                          imagefilterdialog.h  -  description
                             -------------------
    begin                : Fri Jan 18 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IMAGEFILTERDIALOG_H
#define IMAGEFILTERDIALOG_H

#include <qdialog.h>
#include <qimage.h>

/**
  *@author Michael Herder
  */
class QCheckBox;
class QGridLayout;
class QHBox;
class QLabel;
class QPushButton;
class QVBox;

class ImageFilterDialog : public QDialog
{
Q_OBJECT
public: 
	ImageFilterDialog(int preview_size=150,QImage* image=0,QWidget* parent=0);
	~ImageFilterDialog();
  /** No descriptions */
  virtual bool apply(QImage* image,bool emit_progress = true) = 0; //pure virtual
  /** No descriptions */
  virtual void setImage(QImage* image);
  /** No descriptions */
  void setTitle(const QString& title);
  /** No descriptions */
  QVBox* controlsVBox();
  /** No descriptions */
  void updatePreview();
  /** No descriptions */
  void setContinousUpdate(bool state);
  /** No descriptions */
  bool continousUpdate();
  /** No descriptions */
  void showContinousUpdate(bool state);
  /** No descriptions */
  QImage* originalImage();
  /** No descriptions */
  QImage* previewImage();
protected:
  /** No descriptions */
  bool stopped();
  /** No descriptions */
  void setStopped(bool status);
  /** No descriptions */
  virtual void saveConfig();
private: // Private methods
  /** No descriptions */
  void initDialog();
  QImage* mpMiniImage;
  QImage* mpOrigImage;
  QImage mPreviewImage;
  int mPreviewSize;
  QLabel* mpPreviewLabel;
  QLabel* mpTitleLabel;
  QGridLayout* mpMainGrid;
  QVBox* mpControlsVBox;
  QHBox* mpUpdateHBox;
  QCheckBox* mpUpdateCheckBox;
  QPushButton* mpUpdateButton;
  QPushButton* mpOkButton;
  QHBox* mpButtonHb;
  bool mStopped;
private slots: // Protected methods
  /** No descriptions */
  void slotStop();
  /** No descriptions */
  void slotContinousUpdate(bool on);
  /** No descriptions */
  void slotUpdatePreview();
signals:
  void signalFilterProgress(int progress);
public slots: // Public slots
  /** No descriptions */
  void accept();
};

#endif
