/***************************************************************************
 *            dialog_initial.c
 *
 *  Fri Aug 25 10:56:18 2006
 *  Copyright  2006-2007  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/** @file dialog_initial.c
	@author Copyright 2006-2007  Neil Williams <linux@codehelp.co.uk>
	@author Copyright 1999  Robert Lissner, Jay MacDonald,
	@author Copyright 1999  Sam Phillips, Keith Wesolowski 
 */
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "config.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtksheet.h>
#include "types.h"
#include "dialog_initial.h"
#include "menus.h"
#include "dim_list_menu.h"
#include "fileout.h"

void
main_window (QlContext * qlc)
{
	GtkNotebook * notebook;
	/* BOX that fills the list window */
	GtkWidget *list_vbox;
	/* widget inside menu_box */
	GtkWidget *list_mb;
	GtkWidget *data_box;
	GtkWidget *qlstatusbar;
	GdkPixbuf * qlpixbuf;
	GError * qlerr;
	gchar * pixpath;

	qlc->parent = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_signal_connect (qlc->parent, "delete_event",
		G_CALLBACK (file_exit), qlc->parent);
	g_signal_connect (qlc->parent, "destroy",
		G_CALLBACK (file_exit), qlc->parent);
	/* associate the context with the parent window. */
	g_object_set_data (G_OBJECT(qlc->parent),
		QLCONTEXT, qlc);
	gtk_window_set_position (GTK_WINDOW (qlc->parent),
		GTK_WIN_POS_NONE);
	gtk_window_set_resizable (GTK_WINDOW (qlc->parent), TRUE);
	/** \todo move to gconf */
/*	if (!tab->view->width || !tab->view->height || !tab->view->x || !tab->view->y)
	{
		tab->view->width = 600;
		tab->view->height = 400;
		tab->view->x = 100;
		tab->view->y = 100;
	}
	set_window_size_loc (tab->qlc->parent);
*/
	gtk_widget_set_size_request (qlc->parent, 600, 400);

	list_mb = build_list_mb (qlc);
	list_vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (qlc->parent), list_vbox);
	gtk_box_pack_start (GTK_BOX (list_vbox), list_mb, FALSE, TRUE, 0);
	qlerr = NULL;
	qlc->recent_manager = gtk_recent_manager_new ();

	pixpath = g_strconcat (PIXMAPDIR, "/quicklist.xpm", NULL);
	qlpixbuf = gdk_pixbuf_new_from_file (pixpath, &qlerr);
	g_free (pixpath);
	if (qlpixbuf)
	{
		gtk_window_set_icon (GTK_WINDOW (qlc->parent), qlpixbuf);
		gdk_pixbuf_unref (qlpixbuf);
	}

	/* make sheet and add to scroll_win */
	data_box = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (list_vbox), data_box, FALSE, TRUE, 0);
	notebook = GTK_NOTEBOOK(gtk_notebook_new());
	qlc->notebook = notebook;
	gtk_notebook_set_scrollable (qlc->notebook, TRUE);
	gtk_notebook_popup_enable (qlc->notebook);
	gtk_notebook_set_tab_pos (qlc->notebook, GTK_POS_TOP);
	gtk_box_pack_start (GTK_BOX(list_vbox), 
		GTK_WIDGET (qlc->notebook), TRUE, TRUE, 0);
	qlstatusbar = gtk_statusbar_new ();
	gtk_box_pack_end (GTK_BOX (list_vbox), qlstatusbar, FALSE, FALSE, 0);
	gtk_widget_show_all (qlc->parent);
	dim_all_menus (qlc);
}

/** initialise a table of notebook tab data */
QlContext * 
ql_context_init (void)
{
	QlContext * qlc;

	qlc = g_new0 (QlContext, 1);
	qlc->tab_table = g_hash_table_new (g_direct_hash, g_direct_equal);
	return qlc;
}

/** \brief locate the current context

Similar to how glade locates the toplevel widget, this
routine retrieves the data stored in the toplevel widget
and returns the QuickList Context that includes all notebook
tabs.
*/
QlContext *
ql_get_context (GtkWidget * widget)
{
	QlContext * qlc;
	GtkWidget *toplevel;

	g_return_val_if_fail (widget, NULL);
	toplevel = gtk_widget_get_toplevel (GTK_WIDGET(widget));
	if (!toplevel)
		return NULL;
	if (GTK_WIDGET_TOPLEVEL (toplevel))
	{
		qlc = (QlContext*) g_object_get_data (G_OBJECT(toplevel), QLCONTEXT);
		return qlc;
	}
	return NULL;
}

/** \brief initialise data for a notebook tab

Associates a notebook tab with it's view (sheet or report)
and model (the data from the original file).
*/
QlTabData *
ql_new_tabdata (QlContext * qlc)
{
	QlTabData * tab;
	gint nindex;

	nindex = 0;
	tab = g_new0 (QlTabData, 1);
	tab->view = g_new0 (QlViewData, 1);
	tab->file = g_new0 (QlFileData, 1);
	tab->qlc = qlc;
	nindex = gtk_notebook_get_current_page (qlc->notebook);
	nindex++;
	g_hash_table_insert (qlc->tab_table, GINT_TO_POINTER(nindex), tab);
	return tab;
}

/** \brief return the file data for the current notebook tab

Note the use of the context rather than the actual tab -
the dim_menu functions need access via the context.
*/
QlFileData *
ql_get_filedata (QlContext * qlc)
{
	gint index;
	QlTabData * tab;

	g_return_val_if_fail (qlc, NULL);
	g_return_val_if_fail (qlc->notebook, NULL);
	index = gtk_notebook_get_current_page (qlc->notebook);
	if (index < 0)
		return NULL;
	tab = (QlTabData*)g_hash_table_lookup (qlc->tab_table, 
		GINT_TO_POINTER(index));
	return tab->file;
}

QlViewData *
ql_get_viewdata (QlContext * qlc)
{
	gint index;
	QlTabData * tab;

	g_return_val_if_fail (qlc, NULL);
	g_return_val_if_fail (qlc->notebook, NULL);
	index = gtk_notebook_get_current_page (qlc->notebook);
	if (index < 0)
		return NULL;
	tab = (QlTabData*)g_hash_table_lookup (qlc->tab_table, 
		GINT_TO_POINTER(index));
	return tab->view;
}

QlTabData *
ql_get_tabdata (QlContext * qlc)
{
	gint index;
	QlTabData * tab;

	g_return_val_if_fail (qlc, NULL);
	g_return_val_if_fail (qlc->notebook, NULL);
	index = gtk_notebook_get_current_page (qlc->notebook);
	if (index < 0)
		return NULL;
	tab = (QlTabData*)g_hash_table_lookup (qlc->tab_table, 
		GINT_TO_POINTER(index));
	return tab;
}

void
ql_free_context (QlContext *qlc)
{
	g_return_if_fail (qlc);
	g_hash_table_destroy (qlc->tab_table);
	g_object_unref (qlc->recent_manager);
}
