__all__ = ['QTorrent3']

import os, cPickle, sys
from BitTorrent import defaultargs
from QtGui import run_gui
from runner import Runner
from util import check_dir
from controlsock import ControlSocket

class QTorrent3:
	def __init__(self, version):
		self.mainwin = None
		self.version = version
		self.config_dir = os.path.expanduser('~/.qtorrent3')
		check_dir(self.config_dir)
		
		self.torrent_targets = {}
		
		try:
			f = open(os.path.join(self.config_dir, 'targets'))
			targets = cPickle.load(f)
			self.torrent_targets = targets
		except:
			print 'Warning: couldn\'t load targets'
		
		config_ = list(defaultargs.common_options) + list(defaultargs.rare_options)
		self.config = {}
		for e in config_:
			self.config[e[0]] = e[1]
		self.config['data_dir'] = self.config_dir
		self.config['max_uploads'] = 0
		
		self.runner = Runner(self)
		self.controlsocket = ControlSocket(self)
		self.controlsocket.start()
		
		self.mainwin, start_gui = run_gui(self)
		start_gui()
		
		self.controlsocket.stop()
		self.runner.shutdown()
		
	def gui_inited(self):
		self.runner.scan()
	
	def add(self, path, autosave = False):
		self.cleanTargetPaths()
		self.runner.add(path, autosave = autosave)
	
	def cleanTargetPaths(self):
		to_del = []
		for key in self.torrent_targets.keys():
			if not self.runner.torrents.has_key(key):
				to_del.append(key)
		if to_del:
			for key in to_del:
				del self.torrent_targets[key]
			try:
				cPickle.dump(self.torrent_targets, open(os.path.join(self.config_dir, 'targets'), 'w'))
			except:
				print 'Warning: couldn\'t save targets file'
	
	def storeTargetPath(self, infohash, path):
		if path:
			self.torrent_targets[infohash] = path
		elif self.torrent_targets.has_key(infohash):
			del self.torrent_targets[infohash]
		else:
			return
		try:
			cPickle.dump(self.torrent_targets, open(os.path.join(self.config_dir, 'targets'), 'w'))
		except:
			print 'Warning: couldn\'t save targets file'
	
	def getFilename(self, obj):
		if obj.get('autosave', False):
			path = os.path.join(self.config_dir, 'incoming', obj['name'])
			self.storeTargetPath(obj['infohash'], path)
			self.runner.setFilename(path)
		elif self.torrent_targets.has_key(obj['infohash']):
			self.runner.setFilename(self.torrent_targets[obj['infohash']])
		else:
			self.mainwin.getFilename(obj)
	
	def setFilename(self, obj, target):
		if target:
			self.storeTargetPath(obj['infohash'], target)
		self.runner.setFilename(target)
	
	def stats(self, stats, regular):
		if self.mainwin:
			self.mainwin.stats(stats, regular)
	
	def remove(self, infohash):
		self.storeTargetPath(infohash, None)
		self.runner.remove(infohash)

	def stop(self, infohash):
		self.runner.stop(infohash)

	def resume(self, infohash):
		self.runner.resume(infohash)
