#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <QString>
#include <QMap>
#include <QDir>

static QMap<QString, QString> config; 

static void load_config(char *file)
{
	
	FILE *in=fopen(file,"r");
	
	if(in==NULL) {printf ("%s no encontrado\n", file); return;}
	
	char buf[1024];
	char *p, *parameter;
	char *value;
		
	while(!feof(in))
	{
		if( fgets(buf,1024,in)==NULL) break;
		if(feof(in)) break;
		if(buf[0]=='#') continue;
		p=index(buf, '=');
		if( p!=NULL )
		{
			*p='\0';
			parameter=buf;
			value=p+1;
			QString qparameter(QString(parameter).trimmed());
			QString qvalue(QString(value).trimmed());
			config[qparameter]=qvalue;
		}
	}
	
	fclose(in);
}

const QString get_config(char *parameter)
{
	if (config.isEmpty())
	{
		load_config( CONFIG_PATH "/config.rc");
		
		char *home=getenv("HOME");
		
		char home_config[1024];
		
		sprintf(home_config, "%s/.qtoctave", home);
		
		FILE *in=fopen(home_config,"r");
		if( in!= NULL ) fclose(in);
		else
		{
			QDir::home().mkdir(".qtoctave");
		}
		
		sprintf(home_config, "%s/.qtoctave/config.rc", home);
		
		load_config(home_config);
	}
	
	return config.value(parameter);
}


void set_config(QMap<QString,QString> configuration)
{
	QMapIterator<QString, QString> k(configuration);
	while (k.hasNext())
	{
		k.next();
		if( !k.key().isEmpty() )
			config[k.key().trimmed()]=k.value().trimmed();
	}
	
	char home_config[1024];
	
	{
		char *home=getenv("HOME");
		sprintf(home_config, "%s/.qtoctave/config.rc", home);
	}
	
	FILE *out=fopen(home_config,"w");
	
	fprintf(out,"#QtOctave local configuration.\n");
	
	QMapIterator<QString, QString> i(config);
	while (i.hasNext())
	{
		i.next();
		if( !i.key().isEmpty() && !i.value().isEmpty() )
			fprintf(out,"%s=%s\n",i.key().toLocal8Bit().data(),i.value().toLocal8Bit().data());
	}
	
	fclose(out);
}
