/* Copyright (C) 2006 P.L. Lucas
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#ifndef __BASEWIDGET_H__
#define __BASEWIDGET_H__

#include <QWidget>

enum WidgetType {NONE,TERMINAL,TABLE,HELP,DYNAMIC_HELP};

/** This class is base class for windows of QtOctave.
 */
class BaseWidget:public QWidget
{
	Q_OBJECT
	public:
	BaseWidget(QWidget *parent=0);
	/**WidgetType of base widget.
	 * @return Type of widget.
	*/
	WidgetType widgetType();
	protected:
	WidgetType widget_type;
	signals:
	/** This signal is emited when widget is activated.
	*/
	void widget_activated(BaseWidget *w);
	protected:
	void focusInEvent(QFocusEvent * event);
};

#endif
