/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef GAMEANIMATION_H
#define GAMEANIMATION_H

#include "gamenamespace.h"

#include <QtCore/QObject>
#include <QtCore/QTime>
#include <QtGui/QImage>

class GameAnimation: public QObject
{
    Q_OBJECT
public:
    GameAnimation(Game::AnimationType type);
    ~GameAnimation();

    inline void addFrame(const QImage &image) { m_frames.append(image); }

    inline void setSpeed(int speed) 
    { 
        m_speed = speed;         
    }
    inline void setLooping(bool on) 
    {
        m_looping = on;
    }    
    inline void setCurrentFrame(int current_frame) { m_current_frame = current_frame; m_time.restart(); }
    
    inline Game::AnimationType type() const { return m_type; }
    inline int speed() const { return m_speed; }    
    inline bool isLooping() const { return m_looping; }
    QImage currentFrame() const { return frame(m_current_frame); }
    inline QImage frame(int index) const 
    { 
        if (index >= 0 && index < m_frames.size()) 
            return m_frames.at(index);
        else
            return QImage();
    }   

public slots:
    bool update();

signals:
    void finished();
    
private:
    QList<QImage> m_frames;
    Game::AnimationType m_type;
    int m_speed;
    bool m_looping;
    int m_current_frame;
    QTime m_time;    
};

#endif
