/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "classlistgenerator.h"

QString ClassListGenerator::fileName() const { return "qtjambi-classes.qdoc"; }

static bool class_sorter(MetaJavaClass *a, MetaJavaClass *b)
{
    return a->name() < b->name();
}

void ClassListGenerator::generate()
{
    QFile f(fileName());
    if (f.open(QFile::WriteOnly)) {
        QTextStream s(&f);

        s << "/****************************************************************************" << endl
          << "**" << endl
          << "** This is a generated file, please don't touch." << endl
          << "**" << endl
          << "****************************************************************************/" << endl << endl;

        s << "/*!" << endl
          << "\\page qtjambi-classes.html" << endl << endl
          << "\\title Qt Jambi's classes" << endl << endl
          << "This is a list of all Qt Jambi classes." << endl << endl
          << "\\table 100%" << endl;

        MetaJavaClassList classes = Generator::classes();
        qSort(classes.begin(), classes.end(), class_sorter);

        int numColumns = 4;
        int numRows = (classes.size() + numColumns - 1) / numColumns;

        for (int i = 0; i < numRows; ++i) {
            s << endl << "\\row ";
            for (int j=0; j<numColumns; ++j) {
                if (classes.value(i + j * numRows)) {
                    s << "\\o \\l{" << classes.value(i + j * numRows)->qualifiedCppName()
                      << "}{" << classes.value(i + j * numRows)->name() << "} ";
                }
            }

        }

        s << endl << "\\endtable" << endl
          << "*/" << endl;
    }
}
