/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.manualtests;

import org.junit.Test;

import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QFontDialog;
import com.trolltech.qt.gui.QInputDialog;
import com.trolltech.qt.gui.QMessageBox;

import static org.junit.Assert.*;

public class TestManualInjectedCode extends ManualTests {
    
    @Test
    public void testQFontDialogGetFont() {
        QFontDialog.Result result = QFontDialog.getFont();
        
        assertEquals(QMessageBox.StandardButton.Yes, QMessageBox.question(null, "Correct?", "Font selected: " + result.font.family() + " and ok == " + result.ok, new QMessageBox.StandardButtons(QMessageBox.StandardButton.Yes, QMessageBox.StandardButton.No)));
    }
    
    @Test
    public void testQInputDialogGetDouble() {
        Double d = QInputDialog.getDouble(null, "Pick a double", "Here:");
        
        assertEquals(QMessageBox.StandardButton.Yes, QMessageBox.question(null, "Correct?", "Is this the double you selected: " + d, new QMessageBox.StandardButtons(QMessageBox.StandardButton.Yes, QMessageBox.StandardButton.No)));
           
    }

    public static void main(String[] args){
        QApplication.initialize(args);
        new TestManualInjectedCode();
        
        QApplication.instance().dispose();
    }

}
