#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "global.h"
#include "dispatcher.h"
#include "configparams.h"
#include "rigcontrol.h"
#include <QSplashScreen>
#include "configdialog.h"
#ifndef QT_NO_DEBUG
  #include "scopeview.h"
#endif
#include <QCloseEvent>


mainWindow::mainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    statusBarPtr=statusBar();
    setWindowTitle( "QSSTV" );
    setWindowIcon(QPixmap(":/icons/qsstv.png"));
    readSettings();

}

mainWindow::~mainWindow()
{

    delete ui;
}

void mainWindow::init()
{
	QPixmap pixmap(":/icons/splash.png");
	splash=new QSplashScreen(pixmap);
	splash->show();

	dispatchPtr=new dispatcher();
	dispatchPtr->init();

	galMW=ui->galleryWdg;
	rxMW= ui->receiveWidget;
	txMW= ui->transmitWidget;
	galMW->init();
	rxMW->init();
	txMW->init();
	splash->finish(txMW);
	galMW->show();
	rxMW->show();
	txMW->show();

	rxMW->fftFrame()->init(RXSTRIPE,samplingrate);
	rigController->init();
  connect(ui->actionExit, SIGNAL(activated()),SLOT(slotExit()));
  connect(ui->actionConfigure,SIGNAL(activated()),this, SLOT(slotConfigure()));
  connect(ui->actionSound_Control, SIGNAL(activated()), dispatchPtr, SLOT(slotSoundControl()));
  connect(ui->actionAbout_QSSTV, SIGNAL(activated()),SLOT(slotAboutQSSTV()));
  connect(ui->actionAbout_Qt, SIGNAL(activated()),SLOT(slotAboutQt()));
  connect(ui->actionUsers_Guide, SIGNAL(activated()),SLOT(slotUserGuide()));
   connect(ui->actionCalibrate, SIGNAL(activated()),SLOT(slotCalibrate()));

  #ifndef QT_NO_DEBUG
     connect(ui->actionShow_Scope, SIGNAL(activated()),SLOT(slotShowScope()));
     connect(ui->actionLog_Settings, SIGNAL(activated()),SLOT(slotLogSettings()));
     connect(ui->actionReset_Log, SIGNAL(activated()),SLOT(slotResetLog()));
  #else
   // ui->menuOptions->removeAction(ui->actionLogSettings);
    ui->menuOptions->removeAction(ui->actionShow_Scope);
    ui->menuOptions->removeAction(ui->actionLog_Settings);
    ui->menuOptions->removeAction(ui->actionReset_Log);
   #endif
  }


void mainWindow::slotConfigure()
{
  confDiag->exec();
}

#ifndef QT_NO_DEBUG
void mainWindow::slotShowScope()
{
  scopeViewer->show(TRUE,TRUE,TRUE,TRUE);
}
#endif

void mainWindow::slotCalibrate()
{
  //slotGetParams();
  statusBar()->showMessage("Calibrating...");
  dispatchPtr->startCalibration();
  statusBar()->showMessage("Idle...");
}

void mainWindow::slotAboutQSSTV()
{
  QString temp=tr("QSSTV\nVersion: ") + MAJORVERSION + MINORVERSION;
  temp += "\n http://users.telenet.be/on4qz \n(c) 2000-2011 -- Johan Maes - ON4QZ";
  QMessageBox::about(this,tr("About..."),temp);

}

void mainWindow::slotAboutQt()
{
   QMessageBox::aboutQt(this,tr("About..."));

}

void mainWindow::slotUserGuide()
{
  QFileInfo finfo;
  finfo.setFile(docPath,"index.html");
  if (finfo.isReadable())
    {
      QDesktopServices::openUrl("file://"+ finfo.absoluteFilePath());
    }
  else
    {
  QMessageBox::warning(this,"User Guide file locations",
                      "the file:\n" + finfo.absoluteFilePath() + "\ncould not be opened.\n"
                      +"Check if the file exist and you have read access"
                      +"The file could be in another location\n"
                      +"You can change this location in the configuration tables\n"
                      +"Menu->Options->Configuration");
  }
}

void mainWindow::slotLogSettings()
{
  logfile->maskSelect(this);
}

void mainWindow::slotResetLog()
{
 logfile->reset();
}

void mainWindow::slotExit()
{
  writeSettings();
  addToLog ("Main window::Close request",DBRXMAIN);
  closeWindowsEvent* ce = new closeWindowsEvent();
  QApplication::postEvent(dispatchPtr, ce );
}

void  mainWindow::closeEvent ( QCloseEvent *e )
{
  slotExit();
  e->ignore();
}


void mainWindow::readSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("MAIN");
  int windowWidth = qSettings.value("windowWidth", 460 ).toInt();
  int windowHeight = qSettings.value("windowHeight", 530 ).toInt();
  int windowX = qSettings.value( "windowX", -1 ).toInt();
  int windowY = qSettings.value( "windowY", -1 ).toInt();
  resize( windowWidth, windowHeight );
  if ( windowX != -1 || windowY != -1 ) 	move( windowX, windowY );
  setParams();
  qSettings.endGroup();
}

void mainWindow::writeSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("MAIN");
  getParams();
  qSettings.setValue( "windowWidth", width() );
  qSettings.setValue( "windowHeight", height() );
  qSettings.setValue( "windowX", x() );
  qSettings.setValue( "windowY", y() );
  qSettings.endGroup();
}

void mainWindow::getParams()
{
}

void mainWindow::setParams()
{
}
