#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>
#include <qsocketnotifier.h>
#include <alsa/asoundlib.h>
#include "midimap.h"
#include "main.h"
#include "seqdriver.h"

SeqDriver::SeqDriver(QPtrList<MidiMap> *p_midiMapList, QWidget *parent, const char *name) : QWidget(parent, name) {

  midiMapList = p_midiMapList; 
  portCount = 0;
  discardUnmatched = true;
  portUnmatched = 0;
  if (snd_seq_open(&seq_handle, "hw", SND_SEQ_OPEN_DUPLEX, 0) < 0) {
    fprintf(stderr, "Error opening ALSA sequencer.\n");
    exit(1);
  }
  snd_seq_set_client_name(seq_handle, "QMidiRoute");
  clientid = snd_seq_client_id(seq_handle);
  if ((portid_in = snd_seq_create_simple_port(seq_handle, "QMidiRoute",
                                        SND_SEQ_PORT_CAP_WRITE|SND_SEQ_PORT_CAP_SUBS_WRITE,
                                        SND_SEQ_PORT_TYPE_APPLICATION)) < 0) {
    fprintf(stderr, "Error creating sequencer port.\n");
    exit(1);
  }                                     
}

SeqDriver::~SeqDriver(){
}

void SeqDriver::registerPorts(int num) {

  int l1;

  portCount = num;
  for (l1 = 0; l1 < portCount; l1++) {
    if ((portid_out[l1] = snd_seq_create_simple_port(seq_handle, "QMidiRoute",
                                   SND_SEQ_PORT_CAP_READ|SND_SEQ_PORT_CAP_SUBS_READ,
                                   SND_SEQ_PORT_TYPE_APPLICATION)) < 0) {
      fprintf(stderr, "Error creating sequencer port.\n");
      exit(1);
    }
  }                                    
  initSeqNotifier();
}

void SeqDriver::initSeqNotifier() {

  int alsaEventFd = 0;

  struct pollfd pfd[1];
  snd_seq_poll_descriptors(seq_handle, pfd, 1, POLLIN);
  alsaEventFd = pfd[0].fd;
  seqNotifier = new QSocketNotifier(alsaEventFd, QSocketNotifier::Read);
  QObject::connect(seqNotifier, SIGNAL(activated(int)),
                   this, SLOT(procEvents(int)));
}


int SeqDriver::getPortCount() {

  return(portCount);
}

void SeqDriver::procEvents(int fd) {

  int l1;
  snd_seq_event_t *evIn, evOut;
  bool outOfRange, unmatched;

  do {
    snd_seq_event_input(seq_handle, &evIn);
    emit midiEvent(evIn);
    unmatched = true;
    for(l1 = 0; l1 < midiMapList->count(); l1++) {
      if (midiMapList->at(l1)->isMap(evIn)) {
        unmatched = false;
        midiMapList->at(l1)->doMap(evIn, &evOut, &outOfRange);
        if (!outOfRange) {
          snd_seq_ev_set_subs(&evOut);  
          snd_seq_ev_set_direct(&evOut);
          snd_seq_ev_set_source(&evOut, portid_out[midiMapList->at(l1)->portOut]);
          snd_seq_event_output_direct(seq_handle, &evOut);
        }  
      }
    }
    if (!discardUnmatched && unmatched) {
      snd_seq_ev_set_subs(evIn);  
      snd_seq_ev_set_direct(evIn);
      snd_seq_ev_set_source(evIn, portid_out[portUnmatched]);
      snd_seq_event_output_direct(seq_handle, evIn);
    }
  } while (snd_seq_event_input_pending(seq_handle, 0) > 0);  
}

void SeqDriver::setDiscardUnmatched(bool on) {

  discardUnmatched = on;
}

void SeqDriver::setPortUnmatched(int id) {

  portUnmatched = id;
}
