#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>
#include <qlabel.h>
#include <qslider.h> 
#include <qhbox.h>
#include <qvbox.h>
#include <qpushbutton.h>
#include <qsocketnotifier.h>
#include <qstrlist.h>
#include <qspinbox.h>
#include <qinputdialog.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <alsa/asoundlib.h>
#include "mapdata.h"
#include "logwidget.h"
#include "passwidget.h"
#include "gui.h"

Gui::Gui(int p_portCount, QWidget *parent, const char *name) : QVBox(parent, name) {

  setSpacing(10);
  setMargin(10);
  
  mapData = new MapData(this);
  mapData->registerPorts(p_portCount);
  aboutWidget = new QMessageBox(this); 
  tabWidget = new QTabWidget(this);
  logWidget = new LogWidget(tabWidget);
  tabWidget->insertTab(logWidget, "Event Log");
  QObject::connect(mapData->seqDriver, SIGNAL(midiEvent(snd_seq_event_t *)), 
                   logWidget, SLOT(appendEvent(snd_seq_event_t *)));
  passWidget = new PassWidget(p_portCount, tabWidget);
  tabWidget->insertTab(passWidget, "Unmatched");
  QObject::connect(passWidget, SIGNAL(discardToggled(bool)), 
                   mapData->seqDriver, SLOT(setDiscardUnmatched(bool)));
  QObject::connect(passWidget, SIGNAL(newPortUnmatched(int)), 
                   mapData->seqDriver, SLOT(setPortUnmatched(int)));
  QHBox *buttonBox = new QHBox(this);
  QPushButton *addMapButton = new QPushButton("Add Map", buttonBox);
  QObject::connect(addMapButton, SIGNAL(clicked()), this, SLOT(addMap()));
  QPushButton *cloneMapButton = new QPushButton("Clone Map", buttonBox);
  QObject::connect(cloneMapButton, SIGNAL(clicked()), this, SLOT(cloneMap()));
  QPushButton *renameMapButton = new QPushButton("Rename Map", buttonBox);
  QObject::connect(renameMapButton, SIGNAL(clicked()), this, SLOT(renameMap()));
  removeMapButton = new QPushButton("Remove Map", buttonBox);
  removeMapButton->setDisabled(true);
  QObject::connect(removeMapButton, SIGNAL(clicked()), this, SLOT(removeMap()));
}

Gui::~Gui() {

}

void Gui::displayAbout() {
 
    aboutWidget->about(this, "About QMidiRoute", aboutText);
    aboutWidget->raise();
}

void Gui::addMap() {

  QString qs, qs2;
  bool ok;

  removeMapButton->setEnabled(true);    
  qs2.sprintf("Map %d", mapData->midiMapCount() + 1);
  qs = QInputDialog::getText("QMidiRoute: Add MIDI Map", "Add MIDI Map:", 
                              QLineEdit::Normal, qs2, &ok, this);
  MidiMap *midiMap = new MidiMap();
  mapData->addMidiMap(midiMap);   
  MapWidget *mapWidget = new MapWidget(midiMap, mapData->getPortCount(), tabWidget);
  mapData->addMapWidget(mapWidget);
  tabWidget->insertTab(mapWidget, qs);
  tabWidget->showPage(mapWidget);
  mapWidget->mapName = qs;
}

void Gui::addMap(QString qs) {

  removeMapButton->setEnabled(true);    
  MidiMap *midiMap = new MidiMap();
  mapData->addMidiMap(midiMap);   
  MapWidget *mapWidget = new MapWidget(midiMap, mapData->getPortCount(), tabWidget);
  mapData->addMapWidget(mapWidget);
  tabWidget->insertTab(mapWidget, qs);
  tabWidget->showPage(mapWidget);
  mapWidget->mapName = qs;
}

void Gui::cloneMap() {

  QString qs;
  int l1;

  qs = tabWidget->label(tabWidget->currentPageIndex());
  MapWidget *mapWidget = (MapWidget *)tabWidget->currentPage();
  MidiMap *midiMap = new MidiMap();
  mapData->addMidiMap(midiMap);   
  MapWidget *cloneWidget = new MapWidget(midiMap, mapData->getPortCount(), tabWidget);
  mapData->addMapWidget(cloneWidget);
  tabWidget->insertTab(cloneWidget, qs);
  tabWidget->showPage(cloneWidget);
  cloneWidget->mapName = qs;
  cloneWidget->setTypeIn((int)mapWidget->getMidiMap()->typeIn);  
  cloneWidget->setTypeOut((int)mapWidget->getMidiMap()->typeOut);  
  cloneWidget->setChOutMode((int)mapWidget->getMidiMap()->chOutMode);
  cloneWidget->setIndexOutMode((int)mapWidget->getMidiMap()->indexOutMode);
  cloneWidget->setChOut(mapWidget->getMidiMap()->chOut);
  cloneWidget->setIndexOut(mapWidget->getMidiMap()->indexOut);
  cloneWidget->setPortOut(mapWidget->getMidiMap()->portOut);
  for (l1 = 0; l1 < 2; l1++) {
    cloneWidget->setChIn(l1, mapWidget->getMidiMap()->chIn[l1]);
    cloneWidget->setIndexIn(l1, mapWidget->getMidiMap()->indexIn[l1]);
    cloneWidget->setRangeIn(l1, mapWidget->getMidiMap()->rangeIn[l1]);
    cloneWidget->setRangeOut(l1, mapWidget->getMidiMap()->rangeOut[l1]);
  }
}     

void Gui::renameMap() {

  QString qs, qs2;
  bool ok;
  
  qs2 = tabWidget->label(tabWidget->currentPageIndex());
  qs = QInputDialog::getText("QMidiRoute: Rename MIDI Map", "New Name:", 
                              QLineEdit::Normal, qs2, &ok, this);
  tabWidget->setTabLabel(tabWidget->currentPage(), qs);                                
  MapWidget *mapWidget = (MapWidget *)tabWidget->currentPage();
  mapWidget->mapName = qs;
}

void Gui::removeMap() {

  QString qs;

  MapWidget *mapWidget = (MapWidget *)tabWidget->currentPage();
  qs.sprintf("Remove %s ?", tabWidget->label(tabWidget->currentPageIndex()).latin1());
  if (QMessageBox::question(0, "QMidiRoute", qs, QMessageBox::Yes,
                            QMessageBox::No | QMessageBox::Default | QMessageBox::Escape, QMessageBox::NoButton)
      == QMessageBox::No) {
    return;
  }
  mapData->removeMidiMap(mapWidget->getMidiMap());
  mapData->removeMapWidget(mapWidget);
  tabWidget->removePage(mapWidget);
  if (mapData->midiMapCount() < 1) {  
    removeMapButton->setDisabled(true);
  }
}

void Gui::removeMap(int index) {

  QString qs;
  
  MapWidget *mapWidget = mapData->mapWidget(index);
  mapData->removeMidiMap(mapWidget->getMidiMap());
  mapData->removeMapWidget(mapWidget);
  tabWidget->removePage(mapWidget);
  if (mapData->midiMapCount() < 1) {
    removeMapButton->setDisabled(true);
  }                      
}

void Gui::clear() {

  while (mapData->midiMapCount()) {
    removeMap(mapData->midiMapCount() - 1);
  }
}

void Gui::load() {

  QString qs, qs2; 
  
  if (!(qs = QString(QFileDialog::getOpenFileName(QString::null, "QMidiRoute files (*.qmr)")))) {
    return;
  }
  clear();
  QFile f(qs);
  if (!f.open(IO_ReadOnly)) {
    qs2.sprintf("Could not read from file %s.", qs.latin1());
    QMessageBox::information(this, "QMidiRoute", qs2);
    return;
  }          
  QTextStream loadText(&f);
  qs = loadText.readLine();
  QRegExp sep(" ");
  qs2 = qs.section(sep, 0, 0);
  passWidget->setDiscard(qs2.toInt());
  qs2 = qs.section(sep, 1, 1);
  passWidget->setPortUnmatched(qs2.toInt());
  while (!loadText.atEnd()) {
    qs = loadText.readLine();
    addMap(qs);
    mapData->mapWidget(mapData->midiMapCount() - 1)->readMap(&f);
  }
  tabWidget->showPage(mapData->mapWidget(0));
}

void Gui::load(QString name) {

  QString qs, qs2; 
  
  clear();
  QFile f(name);
  if (!f.open(IO_ReadOnly)) {
    qs2.sprintf("Could not read from file %s.", name.latin1());
    QMessageBox::information(this, "QMidiRoute", qs2);
    return;
  }          
  QTextStream loadText(&f);
  qs = loadText.readLine();
  QRegExp sep(" ");
  qs2 = qs.section(sep, 0, 0);
  passWidget->setDiscard(qs2.toInt());
  qs2 = qs.section(sep, 1, 1);
  passWidget->setPortUnmatched(qs2.toInt());
  while (!loadText.atEnd()) {
    qs = loadText.readLine();
    addMap(qs);
    mapData->mapWidget(mapData->midiMapCount() - 1)->readMap(&f);
  }
  tabWidget->showPage(mapData->mapWidget(0));
}

void Gui::save() {

  int l1;
  QString qs, qs2; 
  
  if (!(qs = QString(QFileDialog::getSaveFileName(QString::null, "QMidiRoute files (*.qmr)")))) {
    return;
  }

  QFile f(qs);
  if (!f.open(IO_WriteOnly)) {
    qs2.sprintf("Could not write to file %s.", qs.latin1());
    QMessageBox::information(this, "QMidiRoute", qs2);
    return;
  }          
  QTextStream saveText(&f);
  saveText << (int)mapData->seqDriver->discardUnmatched;
  saveText << " " << mapData->seqDriver->portUnmatched << "\n";
  for (l1 = 0; l1 < mapData->mapWidgetCount(); l1++) {
    saveText << mapData->mapWidget(l1)->mapName.latin1() << "\n";
    mapData->mapWidget(l1)->writeMap(&f);
  }
}
