/*
 * (C) Copyright 2007 by OpenMoko, Inc.
 * Author: Harald Welte <laforge@openmoko.org>
 *         Andy Green <andy@openmoko.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <qi.h>
#include <glamo-regs.h>

#define GLAMO_REG(x)	(*(volatile unsigned short *)(0x08000000 + x))

static void glamo_reg_write(u16 reg, u16 val)
{
	GLAMO_REG(reg) = val;
}

static u16 glamo_reg_read(u16 reg)
{
	return GLAMO_REG(reg);
}


static u16 u16a_gen_init_0x0000[] = {
	0x2020, 0x3650, 0x0002, 0x01FF, 0x0000, 0x0000, 0x0000, 0x0000,
	0x000D, 0x000B, 0x00EE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x1801 /*0x1839*/, 0x0000, 0x2000, 0x0001, 0x0100, 0x0000, 0x0000, 0x0000,
	0x05DB, 0x5231, 0x09C3, 0x8261, 0x0003, 0x0000, 0x0000, 0x0000,
	0x000F, 0x101E, 0xC0C3, 0x101E, 0x000F, 0x0001, 0x030F, 0x020F,
	0x080F, 0x0F0F
};

static u16 u16a_gen_init_0x0200[] = {
	0x0EF0, 0x07FF, 0x0000, 0x0080, 0x0344, 0x0600, 0x0000, 0x0000,
	0x0000, 0x0000, 0x4000, 0xF00E, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
	0x0873, 0xAFAF, 0x0108, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x1002, 0x6006, 0x00FF, 0x0001, 0x0020, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x3210, 0x5432, 0xE100, 0x01D6
};


void glamo_core_init(void)
{
	int bp;

	/* power up PLL1 and PLL2 */
	glamo_reg_write(GLAMO_REG_PLL_GEN7, 0x0000);
	glamo_reg_write(GLAMO_REG_PLL_GEN3, 0x0400);

	/* enable memory clock and get it out of deep pwrdown */
	glamo_reg_write(GLAMO_REG_CLOCK_MEMORY,
		glamo_reg_read(GLAMO_REG_CLOCK_MEMORY) | 8);
	glamo_reg_write(GLAMO_REG_MEM_DRAM2,
			glamo_reg_read(GLAMO_REG_MEM_DRAM2) & (~(1 << 12)));
	glamo_reg_write(GLAMO_REG_MEM_DRAM1,
			glamo_reg_read(GLAMO_REG_MEM_DRAM1) & (~(1 << 12)));
	/*
	 * we just fill up the general hostbus and LCD register sets
	 * with magic values taken from the Linux framebuffer init action
	 */
	for (bp = 0; bp < ARRAY_SIZE(u16a_gen_init_0x0000); bp++)
		glamo_reg_write(0x0 | (bp << 1),
				u16a_gen_init_0x0000[bp]);

	for (bp = 0; bp < ARRAY_SIZE(u16a_gen_init_0x0200); bp++)
		glamo_reg_write(0x200 | (bp << 1),
				u16a_gen_init_0x0200[bp]);

	/* spin until PLL1 lock */
	while (!(glamo_reg_read(GLAMO_REG_PLL_GEN5) & 1))
		;
}

