/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

#include "ui_settings.h"

#include <QFileInfo>
#include <QFileDialog>
#include <QIcon>
#include <QPixmap>
#include <QColor>
#include <QColorDialog>
#include <QWhatsThis>

#include "config.h"

class Settings : public QDialog, private Ui::Settings
{
Q_OBJECT
public:
	Settings( QWidget *parent = 0 );
	~Settings();
private:
//FUNCTIONS
	//no-gui
	void makeConnections();
	//gui
	void showSettings();
//OBJECTS
	Config *config;
private slots:
	void pushButton_color();

	void menulst_restoredefault();
	void devicemap_restoredefault();
	void mtab_restoredefault();

	void browse_menulst();
	void browse_devicemap();
	void browse_mtab();

	void browse_language();

	void contextHelp();
	void OK();
};

#endif
