/***************************************************************************
 *   Copyright (C) 2007 by Κωνσταντίνος Σμάνης   *
 *   kon.smanis@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation                                              *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301 USA                                             *
 ***************************************************************************/

#include "input.h"

Input::Input( QString path, QVector<Device> *items, QWidget* parent ) : QDialog( parent )
{
	setupUi( this );
	connect( pushButton_OK, SIGNAL( pressed() ), this, SLOT( close() ) );

	textEdit_editor->setText( FileTransactions::view( path ) );

	for ( int i = 0; i < tableWidget->columnCount(); i++ )
	{
		( i == 0 ? tableWidget->setColumnWidth( i, 180 ) : tableWidget->setColumnWidth( i, 120 ) );
	}

	tableWidget->setRowCount( items->size() );

	for ( int i = 0; i < items->size() ; i++ )
	{
		QTableWidgetItem *item;
		item = new QTableWidgetItem( QString().setNum(i) );
		tableWidget->setVerticalHeaderItem( i, item );

		item = new QTableWidgetItem( items->at( i ).mountpoint() );
		tableWidget->setItem( i, 0, item );

		item = new QTableWidgetItem( items->at( i ).partition() );
		tableWidget->setItem( i, 1, item );

		item = new QTableWidgetItem( items->at( i ).grubPartition() );
		tableWidget->setItem( i, 2, item );

		item = new QTableWidgetItem( items->at( i ).device() );
		tableWidget->setItem( i, 3, item );

		item = new QTableWidgetItem( items->at( i ).grubDevice() );
		tableWidget->setItem( i, 4, item );

		item = new QTableWidgetItem( items->at( i ).uuid() );
		tableWidget->setItem( i, 5, item );
	}
}
