/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the accessibility project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef ACCESSIBLEOBJECT_H
#define ACCESSIBLEOBJECT_H

#include <QtCore/qobject.h>
#include <QtCore/qhash.h>
#include <QtCore/qrect.h>
#include <QtCore/qstringlist.h>
#include <QtDBus/qdbusextratypes.h>

class QAccessibleInterface;

enum IA2TextCoordinateType
{
    IA2_COORDTYPE_SCREEN_RELATIVE,
    IA2_COORDTYPE_PARENT_RELATIVE
};

enum IA2TextBoundaryType
{
    IA2_TEXT_BOUNDARY_CHAR = 0,
    IA2_TEXT_BOUNDARY_WORD,
    IA2_TEXT_BOUNDARY_SENTENCE,
    IA2_TEXT_BOUNDARY_PARAGRAPH,
    IA2_TEXT_BOUNDARY_LINE,
    IA2_TEXT_BOUNDARY_ALL
};

class AccessibleObject: public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.accessibleObject")

public:
    AccessibleObject(const QString &path, QObject *client, AccessibleObject *parent = 0);
    ~AccessibleObject();

    QString path() const;

    static AccessibleObject *ensureExported(QObject *obj);

public slots:
    inline QObject *clientObject() const { return client; }
    inline QAccessibleInterface *accessibleInterface() const { return iface; }

    QString name() const;
    QString className() const;
    QString description() const;
    QString role() const;
    QString localizedRoleName() const;
    int states() const;
    QRect location() const;
    bool setFocus();
    int indexInParent() const;

    // Navigation
    int childCount();
    QList<QDBusObjectPath> children();
    QString hitTest(int x, int y);
    QDBusObjectPath navigate(int direction);

protected:
    void updateChildren();
    inline void setChildrenDirty() { childrenDirty = true; }
    static AccessibleObject *exportedObject(QObject *obj);
    AccessibleObject *registerChild(QObject *child);

    virtual QObjectList clientChildren() const;

private slots:
    void objectDestroyed();

private:
    friend class AccessibleApplication;

    QString uniqueName(QObject *child);

    QAccessibleInterface *iface;
    QObject *client;
    QString dPath;
    bool childrenDirty;
    int uniqueChildId;
    QStringList childrenPaths;
};

#endif
