/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the accessibility project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "accessiblecomponentadaptor.h"
#include "accessibleobject.h"

#include <qaccessible.h>
#include <qwidget.h>

AccessibleComponentAdaptor::AccessibleComponentAdaptor(QObject *parent)
    : QDBusAbstractAdaptor(parent)
{
    setAutoRelaySignals(true);
}

AccessibleComponentAdaptor::~AccessibleComponentAdaptor()
{
}

int AccessibleComponentAdaptor::background()
{
    QColor color = static_cast<AccessibleObject *>(parent())->accessibleInterface()->backgroundColor();
    return color.isValid() ? int(color.rgba()) : 0;
}

int AccessibleComponentAdaptor::foreground()
{
    QColor color = static_cast<AccessibleObject *>(parent())->accessibleInterface()->foregroundColor();
    return color.isValid() ? int(color.rgba()) : 0;
}

QPoint AccessibleComponentAdaptor::locationInParent()
{
    QPoint result;

    QAccessibleInterface *iface = static_cast<AccessibleObject *>(parent())->accessibleInterface();
    QAccessibleInterface *parent = 0;
    iface->navigate(QAccessible::Ancestor, 1, &parent);
    if (!parent)
        return result;

    QRect parentRect = parent->rect(0);
    QRect childRect = iface->rect(0);

    delete parent;

    return childRect.topLeft() - parentRect.topLeft();
}

