/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "userslistwgt.h"
#include "globals.h"

#include <QLayout>
#include <QLabel>
#include <QIcon>
#include <QPixmap>
#include <QSize>
#include <QFont>

#include "singlemessagewgt.h"
#include "userwgt.h"
#include "userinfo.h"

UsersListWgt::UsersListWgt(QWidget *parent)
 : QListWidget(parent)
{
  m_menu             = new QMenu  (this);
  m_singleMessageAct = new QAction(this);
  m_showInfoAct      = new QAction(this);
  m_sendFileAct      = new QAction(this);
  m_privateChatAct   = new QAction(this);

  m_menu->addAction(m_singleMessageAct);
  m_menu->addAction(m_sendFileAct);
  m_menu->addAction(m_privateChatAct);

  m_sendFileAct     ->setIcon(QIcon(":/images/send-file.png"));
  m_singleMessageAct->setIcon(QIcon(":/images/single-message.png"));
  m_privateChatAct  ->setIcon(QIcon(":/images/private-chat.png"));

  connect(m_singleMessageAct, SIGNAL(triggered(bool)),
          this              , SLOT  (slot_singleMessage()));

  connect(m_sendFileAct     , SIGNAL(triggered(bool)),
          this              , SLOT  (slot_sendFile()));

  connect(m_privateChatAct  , SIGNAL(triggered(bool)),
          this              , SLOT  (slot_privateChat()));

  connect(this              , SIGNAL(     itemDoubleClicked(QListWidgetItem*)),
          this              , SLOT  (send_itemDoubleClicked(QListWidgetItem*)));

  setIconSize(QSize(32 + 16 + 16, 32));// TODO sdelat' nastraivaemyi razmer

  setSortingEnabled(true);

  setMouseTracking(true);

  retranslate();
}
//\*****************************************************************************
UsersListWgt::~UsersListWgt()
{
  qDebug("[~UsersListWgt]\n");
}
//\*****************************************************************************
void UsersListWgt::retranslate()
{
  m_singleMessageAct->setText(tr("Send Single Message.."  ));
  m_showInfoAct     ->setText(tr("Show User Information.."));
  m_sendFileAct     ->setText(tr("Send File.."));
  m_privateChatAct  ->setText(tr("Private Chat.."));
}
//\*****************************************************************************
void UsersListWgt::addUser(UserWgt* user)
{
  QFont fnt;

  Q_ASSERT(NULL != user);

  if(user->info())
  {
    qDebug("[UsersListWgt::addUser]: status = %d", user->info()->status());

    if(user->info()->status() == Globals::FREE || user->info()->status() == Globals::READY4CHAT)
      fnt.setBold(true);

    user->setFont(fnt);
    user->setText(user->info()->nickname() + " (" + user->info()->programVerName() + ")");
  }

  if(row(user) >= 0)
    setItemHidden(user, false);
  else
    addItem(user);

  user->setSizeHint(QSize(1, 32));

  qDebug("[UsersListWgt::addUser]: added: '%s'", user->text().toLocal8Bit().data());
}
//\*****************************************************************************
void UsersListWgt::hideUser(UserWgt* user)
{
  takeItem(row(user));
}
//\*****************************************************************************
void UsersListWgt::clear()
{
  int cnt = count();
  UserWgt* item_;

  while(count() || cnt)
  {
    item_ = (UserWgt*)item(0);

    if(NULL != item_)
    {
      item_->setText("");
      takeItem(0);
    }

    --cnt;
  }
}
//\*****************************************************************************
void UsersListWgt::slot_singleMessage()
{
  UserWgt*          usr = (UserWgt*)(currentItem());
  SingleMessageWgt* smw = new SingleMessageWgt(QString(tr("Message to ")) + usr->info()->nickname(),
                                               "",
                                                QHostAddress(usr->info()->ip())
                                               );

  connect(smw , SIGNAL(singleMessage    (QString, QHostAddress)),
          this, SIGNAL(singleMessage    (QString, QHostAddress)));

  smw->show();
}
//\*****************************************************************************
void UsersListWgt::slot_sendFile()
{
  UserWgt* usr = (UserWgt*)(currentItem());

  if(usr)
    emit wantSendFile(QHostAddress(usr->info()->ip()));
}
//\*****************************************************************************
void UsersListWgt::mousePressEvent (QMouseEvent * ev)
{
  int i;
  int nitems   = 0;
  int cnt      = count();
  int height   = 0;

  for(i = 0; i < cnt; i++)
    if(!isItemHidden(item(i)))
      nitems++;

  if(nitems)
    height = (item(0)->sizeHint().height()) * nitems;

  if(ev->button() == Qt::RightButton && currentItem() && isItemSelected(currentItem()) &&
    !isItemHidden(currentItem())     && ev->y() < height )
  {
//     UserWgt* usr = (UserWgt*)(currentItem());
//     m_privateChatAct  ->setText((tr("Private Chat with ") + usr->info()->nickname()));
//     m_sendFileAct     ->setText((tr("Send File to "     ) + usr->info()->nickname()));
//     m_singleMessageAct->setText((tr("Single Message to ") + usr->info()->nickname()));
    m_menu->popup(ev->globalPos());
  }

  QListWidget::mousePressEvent(ev);
}
//\*****************************************************************************
void UsersListWgt::slot_privateChat()
{
  UserWgt* usr = (UserWgt*)(currentItem());

  if(usr)
    emit wantPrivateChat(usr->info()->nickname(), QHostAddress(usr->info()->ip()));
}
//\*****************************************************************************
void UsersListWgt::send_itemDoubleClicked(QListWidgetItem* item)
{
  emit itemDoubleClicked((UserWgt*)item);
}
